/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    static void installIfAsked(LoggerContext loggerContext) {
        String slClass = OptionHelper.getSystemProperty("logback.statusListenerClass");
        if (!OptionHelper.isEmpty(slClass)) {
            StatusListenerConfigHelper.addStatusListener(loggerContext, slClass);
        }
    }

    static void addStatusListener(LoggerContext loggerContext, String listenerClass) {
        StatusListener listener = null;
        if ("SYSOUT".equalsIgnoreCase(listenerClass)) {
            listener = new OnConsoleStatusListener();
        } else {
            try {
                listener = (StatusListener)OptionHelper.instantiateByClassName(listenerClass, StatusListener.class, loggerContext);
                if (listener instanceof ContextAware) {
                    ((ContextAware)((Object)listener)).setContext(loggerContext);
                }
                if (listener instanceof LifeCycle) {
                    ((LifeCycle)((Object)listener)).start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (listener != null) {
            loggerContext.getStatusManager().add(listener);
        }
    }
}

