/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.nonull;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.nonull.NonNull;
import com.urbancode.commons.util.nonull.NonNullSet;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
final class NonNullSortedMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V>,
Serializable,
NonNull {
    private static final long serialVersionUID = 1L;
    private final SortedMap<K, V> delegate;

    NonNullSortedMap(SortedMap<K, V> delegate) {
        this.delegate = Check.nonNull(delegate, "delegate");
    }

    @Override
    public V put(K key, V value) {
        Check.nonNull(key, "key");
        Check.nonNull(value, "value");
        return this.delegate.put(key, value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new NonNullSet<Map.Entry<K, V>>(this.delegate.entrySet());
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.delegate.comparator();
    }

    @Override
    public K firstKey() {
        return this.delegate.firstKey();
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.delegate.headMap(toKey);
    }

    @Override
    public K lastKey() {
        return this.delegate.lastKey();
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return new NonNullSortedMap<K, V>(this.delegate.subMap(fromKey, toKey));
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return new NonNullSortedMap<K, V>(this.delegate.tailMap(fromKey));
    }
}

