/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.jfrog.artifactory.client.model.ItemPermission;
import org.jfrog.artifactory.client.model.Privilege;
import org.jfrog.artifactory.client.model.RepoPath;
import org.jfrog.artifactory.client.model.Subject;

public class ItemPermissionImpl
implements ItemPermission {
    private final RepoPath repoPath;
    private final List<Privilege> privileges;
    private final Subject subject;

    public ItemPermissionImpl(RepoPath repoPath, Subject subject, List<Privilege> privileges) {
        this.repoPath = repoPath;
        this.subject = subject;
        this.privileges = new ArrayList<Privilege>(privileges);
    }

    @Override
    public RepoPath getRepoPath() {
        return this.repoPath;
    }

    @Override
    public List<Privilege> getPrivileges() {
        return this.privileges;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public boolean isAllowedTo(Privilege ... privileges) {
        for (Privilege privilege : privileges) {
            if (this.privileges.contains((Object)privilege)) continue;
            return false;
        }
        return true;
    }
}

