/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.lang.Closure;
import groovyx.net.http.AuthConfig;
import groovyx.net.http.ContentEncoding;
import groovyx.net.http.ContentEncodingRegistry;
import groovyx.net.http.ContentType;
import groovyx.net.http.EncoderRegistry;
import groovyx.net.http.HttpContextDecorator;
import groovyx.net.http.HttpResponseDecorator;
import groovyx.net.http.HttpResponseException;
import groovyx.net.http.Method;
import groovyx.net.http.ParserRegistry;
import groovyx.net.http.ResponseParseException;
import groovyx.net.http.Status;
import groovyx.net.http.StringHashMap;
import groovyx.net.http.URIBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MethodClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPBuilder {
    private HttpClient client;
    protected URIBuilder defaultURI = null;
    protected AuthConfig auth = new AuthConfig(this);
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Object defaultContentType = ContentType.ANY;
    protected Object defaultRequestContentType = null;
    protected boolean autoAcceptHeader = true;
    protected final Map<Object, Closure> defaultResponseHandlers = new StringHashMap<Closure>(this.buildDefaultResponseHandlers());
    protected ContentEncodingRegistry contentEncodingHandler = new ContentEncodingRegistry();
    protected final Map<Object, Object> defaultRequestHeaders = new StringHashMap<Object>();
    protected EncoderRegistry encoders = new EncoderRegistry();
    protected ParserRegistry parsers = new ParserRegistry();

    public HTTPBuilder() {
        this.setContentEncoding(new Object[]{ContentEncoding.Type.GZIP, ContentEncoding.Type.DEFLATE});
    }

    public HTTPBuilder(Object defaultURI) throws URISyntaxException {
        this.setUri(defaultURI);
    }

    public HTTPBuilder(Object defaultURI, Object defaultContentType) throws URISyntaxException {
        this.setUri(defaultURI);
        this.defaultContentType = defaultContentType;
    }

    public Object get(Map<String, ?> args) throws ClientProtocolException, IOException, URISyntaxException {
        return this.get(args, null);
    }

    public Object get(Map<String, ?> args, Closure responseClosure) throws ClientProtocolException, IOException, URISyntaxException {
        RequestConfigDelegate delegate = new RequestConfigDelegate(new HttpGet(), this.defaultContentType, this.defaultRequestHeaders, this.defaultResponseHandlers);
        delegate.setPropertiesFromMap(args);
        if (responseClosure != null) {
            delegate.getResponse().put((Object)Status.SUCCESS, responseClosure);
        }
        return this.doRequest(delegate);
    }

    public Object post(Map<String, ?> args) throws ClientProtocolException, URISyntaxException, IOException {
        return this.post(args, null);
    }

    public Object post(Map<String, ?> args, Closure responseClosure) throws URISyntaxException, ClientProtocolException, IOException {
        RequestConfigDelegate delegate = new RequestConfigDelegate(new HttpPost(), this.defaultContentType, this.defaultRequestHeaders, this.defaultResponseHandlers);
        delegate.setRequestContentType(ContentType.URLENC.toString());
        delegate.setPropertiesFromMap(args);
        if (responseClosure != null) {
            delegate.getResponse().put(Status.SUCCESS.toString(), responseClosure);
        }
        return this.doRequest(delegate);
    }

    public Object request(Method method, Closure configClosure) throws ClientProtocolException, IOException {
        return this.doRequest(this.defaultURI.toURI(), method, this.defaultContentType, configClosure);
    }

    public Object request(Method method, Object contentType, Closure configClosure) throws ClientProtocolException, IOException {
        return this.doRequest(this.defaultURI.toURI(), method, contentType, configClosure);
    }

    public Object request(Object uri, Method method, Object contentType, Closure configClosure) throws ClientProtocolException, IOException, URISyntaxException {
        return this.doRequest(URIBuilder.convertToURI(uri), method, contentType, configClosure);
    }

    protected Object doRequest(URI uri, Method method, Object contentType, Closure configClosure) throws ClientProtocolException, IOException {
        HttpRequestBase reqMethod;
        try {
            reqMethod = method.getRequestType().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        reqMethod.setURI(uri);
        RequestConfigDelegate delegate = new RequestConfigDelegate(reqMethod, contentType, this.defaultRequestHeaders, this.defaultResponseHandlers);
        configClosure.setDelegate(delegate);
        configClosure.setResolveStrategy(1);
        configClosure.call((Object)reqMethod);
        return this.doRequest(delegate);
    }

    protected Object doRequest(final RequestConfigDelegate delegate) throws ClientProtocolException, IOException {
        delegate.encodeBody();
        HttpRequestBase reqMethod = delegate.getRequest();
        final Object contentType = delegate.getContentType();
        if (this.autoAcceptHeader) {
            String acceptContentTypes = contentType.toString();
            if (contentType instanceof ContentType) {
                acceptContentTypes = ((ContentType)((Object)contentType)).getAcceptHeader();
            }
            reqMethod.setHeader("Accept", acceptContentTypes);
        }
        reqMethod.setURI(delegate.getUri().toURI());
        if (reqMethod.getURI() == null) {
            throw new IllegalStateException("Request URI cannot be null");
        }
        this.log.debug(reqMethod.getMethod() + " " + reqMethod.getURI());
        Map<?, ?> headers = delegate.getHeaders();
        for (Object key : headers.keySet()) {
            Object val = headers.get(key);
            if (key == null) continue;
            if (val == null) {
                reqMethod.removeHeaders(key.toString());
                continue;
            }
            reqMethod.setHeader(key.toString(), val.toString());
        }
        ResponseHandler<Object> responseHandler = new ResponseHandler<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                HttpResponseDecorator resp = new HttpResponseDecorator(response, delegate.getContext(), null);
                try {
                    int status = resp.getStatusLine().getStatusCode();
                    Closure responseClosure = delegate.findResponseHandler(status);
                    HTTPBuilder.this.log.debug("Response code: " + status + "; found handler: " + responseClosure);
                    Object[] closureArgs = null;
                    switch (responseClosure.getMaximumNumberOfParameters()) {
                        case 1: {
                            closureArgs = new Object[]{resp};
                            break;
                        }
                        case 2: {
                            HttpEntity entity = resp.getEntity();
                            try {
                                if (entity == null || entity.getContentLength() == 0L) {
                                    closureArgs = new Object[]{resp, null};
                                    break;
                                }
                                closureArgs = new Object[]{resp, HTTPBuilder.this.parseResponse(resp, contentType)};
                                break;
                            }
                            catch (Exception ex) {
                                Header h = entity.getContentType();
                                String respContentType = h != null ? h.getValue() : null;
                                HTTPBuilder.this.log.warn("Error parsing '" + respContentType + "' response", ex);
                                throw new ResponseParseException(resp, (Throwable)ex);
                            }
                        }
                        default: {
                            throw new IllegalArgumentException("Response closure must accept one or two parameters");
                        }
                    }
                    Object returnVal = responseClosure.call(closureArgs);
                    HTTPBuilder.this.log.trace("response handler result: " + returnVal);
                    Object v = returnVal;
                    return v;
                }
                finally {
                    HttpEntity entity = resp.getEntity();
                    if (entity != null) {
                        entity.consumeContent();
                    }
                }
            }
        };
        return this.getClient().execute(reqMethod, responseHandler, (HttpContext)delegate.getContext());
    }

    protected Object parseResponse(HttpResponse resp, Object contentType) throws HttpResponseException {
        if (resp.getEntity() == null) {
            this.log.debug("Response contains no entity.  Parsed data is null.");
            return null;
        }
        String responseContentType = contentType.toString();
        try {
            if (ContentType.ANY.toString().equals(responseContentType)) {
                responseContentType = ParserRegistry.getContentType(resp);
            }
        }
        catch (RuntimeException ex) {
            this.log.warn("Could not parse content-type: " + ex.getMessage());
            responseContentType = ContentType.BINARY.toString();
        }
        Object parsedData = null;
        Closure parser = this.parsers.getAt(responseContentType);
        if (parser == null) {
            this.log.warn("No parser found for content-type: " + responseContentType);
        } else {
            this.log.debug("Parsing response as: " + responseContentType);
            parsedData = parser.call((Object)resp);
            if (parsedData == null) {
                this.log.warn("Parser returned null!");
            } else {
                this.log.debug("Parsed data to instance of: " + parsedData.getClass());
            }
        }
        return parsedData;
    }

    protected Map<Object, Closure> buildDefaultResponseHandlers() {
        StringHashMap<Closure> map = new StringHashMap<Closure>();
        map.put(Status.SUCCESS, new MethodClosure((Object)this, "defaultSuccessHandler"));
        map.put(Status.FAILURE, new MethodClosure((Object)this, "defaultFailureHandler"));
        return map;
    }

    protected Object defaultSuccessHandler(HttpResponseDecorator resp, Object parsedData) throws ResponseParseException {
        try {
            if (parsedData instanceof InputStream) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                DefaultGroovyMethods.leftShift((OutputStream)buffer, (InputStream)parsedData);
                parsedData = new ByteArrayInputStream(buffer.toByteArray());
            } else if (parsedData instanceof Reader) {
                StringWriter buffer = new StringWriter();
                DefaultGroovyMethods.leftShift(buffer, (Object)((Reader)parsedData));
                parsedData = new StringReader(buffer.toString());
            } else if (parsedData instanceof Closeable) {
                this.log.warn("Parsed data is streaming, but will be accessible after the network connection is closed.  Use at your own risk!");
            }
            return parsedData;
        }
        catch (IOException ex) {
            throw new ResponseParseException(resp, (Throwable)ex);
        }
    }

    protected void defaultFailureHandler(HttpResponseDecorator resp) throws HttpResponseException {
        throw new HttpResponseException(resp);
    }

    public Map<?, Closure> getHandler() {
        return this.defaultResponseHandlers;
    }

    public ParserRegistry getParser() {
        return this.parsers;
    }

    public EncoderRegistry getEncoder() {
        return this.encoders;
    }

    public void setContentType(Object ct) {
        this.defaultContentType = ct;
    }

    public Object getContentType() {
        return this.defaultContentType;
    }

    public void setAutoAcceptHeader(boolean shouldSendAcceptHeader) {
        this.autoAcceptHeader = shouldSendAcceptHeader;
    }

    public boolean isAutoAcceptHeader() {
        return this.autoAcceptHeader;
    }

    public void setContentEncoding(Object ... encodings) {
        HttpClient client = this.getClient();
        if (!(client instanceof AbstractHttpClient)) {
            throw new IllegalStateException("The HttpClient is not an AbstractHttpClient!");
        }
        this.contentEncodingHandler.setInterceptors((AbstractHttpClient)client, encodings);
    }

    public void setUri(Object uri) throws URISyntaxException {
        this.defaultURI = uri != null ? new URIBuilder(URIBuilder.convertToURI(uri)) : null;
    }

    public Object getUri() {
        return this.defaultURI;
    }

    public void setHeaders(Map<?, ?> headers) {
        this.defaultRequestHeaders.clear();
        if (headers == null) {
            return;
        }
        for (Object key : headers.keySet()) {
            Object val = headers.get(key);
            if (val == null) continue;
            this.defaultRequestHeaders.put(key.toString(), val.toString());
        }
    }

    public Map<?, ?> getHeaders() {
        return this.defaultRequestHeaders;
    }

    public HttpClient getClient() {
        if (this.client == null) {
            BasicHttpParams defaultParams = new BasicHttpParams();
            defaultParams.setParameter("http.protocol.cookie-datepatterns", Arrays.asList("EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ss z"));
            this.client = this.createClient(defaultParams);
        }
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    protected HttpClient createClient(HttpParams params) {
        return new DefaultHttpClient(params);
    }

    public AuthConfig getAuth() {
        return this.auth;
    }

    public void setAuthConfig(AuthConfig ac) {
        this.auth = ac;
    }

    public void setEncoderRegistry(EncoderRegistry er) {
        this.encoders = er;
    }

    public void setParserRegistry(ParserRegistry pr) {
        this.parsers = pr;
    }

    public void setContentEncodingRegistry(ContentEncodingRegistry cer) {
        this.contentEncodingHandler = cer;
    }

    public void setProxy(String host, int port, String scheme) {
        this.getClient().getParams().setParameter("http.route.default-proxy", new HttpHost(host, port, scheme));
    }

    public void ignoreSSLIssues() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        TrustStrategy trustStrat = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authtype) throws CertificateException {
                return true;
            }
        };
        SSLSocketFactory sslSocketFactory = new SSLSocketFactory(trustStrat, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        this.getClient().getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, sslSocketFactory));
    }

    public void shutdown() {
        this.getClient().getConnectionManager().shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RequestConfigDelegate {
        private HttpRequestBase request;
        private Object contentType;
        private Object requestContentType;
        private Map<Object, Closure> responseHandlers = new StringHashMap<Closure>();
        private URIBuilder uri;
        private Map<Object, Object> headers = new StringHashMap<Object>();
        private HttpContextDecorator context = new HttpContextDecorator();
        private Object body;

        public RequestConfigDelegate(HttpRequestBase request, Object contentType, Map<?, ?> defaultRequestHeaders, Map<?, Closure> defaultResponseHandlers) {
            if (request == null) {
                throw new IllegalArgumentException("Internal error - HttpRequest instance cannot be null");
            }
            this.request = request;
            this.headers.putAll(defaultRequestHeaders);
            this.contentType = contentType;
            if (HTTPBuilder.this.defaultRequestContentType != null) {
                this.requestContentType = HTTPBuilder.this.defaultRequestContentType.toString();
            }
            this.responseHandlers.putAll(defaultResponseHandlers);
            URI uri = request.getURI();
            if (uri != null) {
                this.uri = new URIBuilder(uri);
            }
        }

        public RequestConfigDelegate(Map<String, ?> args, HttpRequestBase request, Closure successHandler) throws URISyntaxException {
            this(request, hTTPBuilder.defaultContentType, hTTPBuilder.defaultRequestHeaders, hTTPBuilder.defaultResponseHandlers);
            if (successHandler != null) {
                this.responseHandlers.put(Status.SUCCESS.toString(), successHandler);
            }
            this.setPropertiesFromMap(args);
        }

        public URIBuilder getUri() {
            return this.uri;
        }

        public void setUri(Object uri) throws URISyntaxException {
            if (uri instanceof URIBuilder) {
                this.uri = (URIBuilder)uri;
            }
            this.uri = new URIBuilder(URIBuilder.convertToURI(uri));
        }

        protected HttpRequestBase getRequest() {
            return this.request;
        }

        protected Object getContentType() {
            return this.contentType;
        }

        protected void setContentType(Object ct) {
            this.contentType = ct == null ? HTTPBuilder.this.defaultContentType : ct;
        }

        protected Object getRequestContentType() {
            if (this.requestContentType != null) {
                return this.requestContentType;
            }
            return this.getContentType();
        }

        protected void setRequestContentType(Object ct) {
            this.requestContentType = ct;
        }

        protected void setPropertiesFromMap(Map<String, ?> args) throws URISyntaxException {
            Object body;
            Object contentType;
            Object path;
            Map headers;
            String queryString;
            if (args == null) {
                return;
            }
            if (args.containsKey("url")) {
                throw new IllegalArgumentException("The 'url' parameter is deprecated; use 'uri' instead");
            }
            Object uri = args.remove("uri");
            if (uri == null) {
                uri = HTTPBuilder.this.defaultURI;
            }
            if (uri == null) {
                throw new IllegalStateException("Default URI is null, and no 'uri' parameter was given");
            }
            this.uri = new URIBuilder(URIBuilder.convertToURI(uri));
            Map query = (Map)args.remove("params");
            if (query != null) {
                HTTPBuilder.this.log.warn("'params' argument is deprecated; use 'query' instead.");
                this.uri.setQuery(query);
            }
            if ((queryString = (String)args.remove("queryString")) != null) {
                this.uri.setRawQuery(queryString);
            }
            if ((query = (Map)args.remove("query")) != null) {
                this.uri.addQueryParams(query);
            }
            if ((headers = (Map)args.remove("headers")) != null) {
                this.getHeaders().putAll(headers);
            }
            if ((path = args.remove("path")) != null) {
                this.uri.setPath(path.toString());
            }
            if ((contentType = args.remove("contentType")) != null) {
                this.setContentType(contentType);
            }
            if ((contentType = args.remove("requestContentType")) != null) {
                this.setRequestContentType(contentType);
            }
            if ((body = args.remove("body")) != null) {
                this.setBody(body);
            }
            if (args.size() > 0) {
                String invalidArgs = "";
                for (String k : args.keySet()) {
                    invalidArgs = invalidArgs + k + ",";
                }
                throw new IllegalArgumentException("Unexpected keyword args: " + invalidArgs);
            }
        }

        public void setHeaders(Map<?, ?> newHeaders) {
            this.headers.putAll(newHeaders);
        }

        public Map<?, ?> getHeaders() {
            return this.headers;
        }

        public void send(Object contentType, Object requestBody) {
            this.setRequestContentType(contentType);
            this.setBody(requestBody);
        }

        public void setBody(Object body) {
            this.body = body;
        }

        public void encodeBody() {
            if (this.body == null) {
                return;
            }
            if (!(this.request instanceof HttpEntityEnclosingRequest)) {
                throw new IllegalArgumentException("Cannot set a request body for a " + this.request.getMethod() + " method");
            }
            Closure encoder = HTTPBuilder.this.encoders.getAt(this.getRequestContentType());
            if (encoder == null) {
                throw new IllegalArgumentException("No encoder found for request content type " + this.getRequestContentType());
            }
            HttpEntity entity = encoder.getMaximumNumberOfParameters() == 2 ? (HttpEntity)encoder.call(this.body, this.getRequestContentType()) : (HttpEntity)encoder.call(this.body);
            ((HttpEntityEnclosingRequest)((Object)this.request)).setEntity(entity);
        }

        protected Closure findResponseHandler(int statusCode) {
            Closure handler = this.getResponse().get(Integer.toString(statusCode));
            if (handler == null) {
                handler = this.getResponse().get(Status.find(statusCode).toString());
            }
            return handler;
        }

        public Map<Object, Closure> getResponse() {
            return this.responseHandlers;
        }

        public HttpContextDecorator getContext() {
            return this.context;
        }

        public void setContext(HttpContext ctx) {
            this.context = new HttpContextDecorator(ctx);
        }
    }
}

