/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.artifactory.client.model;

public enum Privilege {
    ADMIN('m'),
    DELETE('d'),
    DEPLOY('w'),
    ANNOTATE('n'),
    READ('r');

    private char abbreviation;

    private Privilege(char abbreviation) {
        this.abbreviation = abbreviation;
    }

    public char getAbbreviation() {
        return this.abbreviation;
    }

    public static Privilege fromAbbreviation(char abbreviation) {
        for (Privilege privilege : Privilege.values()) {
            if (privilege.abbreviation != abbreviation) continue;
            return privilege;
        }
        throw new IllegalArgumentException("No Privilege for " + abbreviation + " found.");
    }
}

