import com.urbancode.air.*
import com.urbancode.air.plugin.clearcasebasesnapshot.*

//standard preamble stuff
def apTool = new AirPluginTool(args[0], args[1]);
def props = apTool.getStepProperties();
ClearCaseHelper clearCaseHelper = new ClearCaseHelper(apTool, props);

if (clearCaseHelper.label == null) {
    throw new IllegalStateException("A label must be specified")
}

List<String> vobNameList = clearCaseHelper.getVobNameList();

//create the label type
vobNameList.each { vobName ->
    try {
        clearCaseHelper.makeLabelTypeCommand(vobName)
    }
    catch (Exception e) {
        //assume the label type exists
    }
}

//now apply the label
clearCaseHelper.applyLabels(vobNameList);
