import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def workDir = new File('.').canonicalFile

final def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def dateParser = new DateParser();

final def stepProps = apTool.getStepProperties();

final def clearToolCommand  = stepProps['source/repo/commandPath'] ?: 'cleartool'

final def srcName           = stepProps['source'];
final String viewName       = stepProps['source/viewName']
final String viewPath       = stepProps['source/viewPath']
final File dir              = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory
final String loadRules      = stepProps['source/loadRules']

//------------------------------------------------------------------------------
// PREPARE COMMAND LINE
//------------------------------------------------------------------------------

// create the directory ahead of time
dir.mkdirs()

SCMCleanup clean = new SCMCleanup();
clean.scmCommand = clearToolCommand;
clean.directory = dir
clean.loadRules = loadRules
clean.viewName = viewName
clean.viewPath = viewPath
clean.execute()
