import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def workDir = new File('.').canonicalFile

final def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def dateParser = new DateParser();

final def stepProps = apTool.getStepProperties();

final def clearToolCommand  = stepProps['source/repo/commandPath'] ?: 'cleartool'

final def srcName           = stepProps['source'];
final File dir              = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory
final String viewName       = stepProps['source/viewName']
final String viewPath       = stepProps['source/viewPath']
final String message        = stepProps['message']
final String label          = stepProps['label']
final String labelBehavior  = stepProps['source/labelBehavior']
final String components     = stepProps['source/components']
final boolean forceLabel    = Boolean.valueOf(stepProps['source/forceLabelOnNoChanges'])
final String alternateView  = stepProps['source/alternateView']

//------------------------------------------------------------------------------
// PREPARE COMMAND LINE
//------------------------------------------------------------------------------

// create the directory ahead of time
dir.mkdirs()

SCMTag tag = new SCMTag();
tag.scmCommand = clearToolCommand;
tag.directory = dir
tag.message = message
tag.labelBehavior = labelBehavior != "default" ? labelBehavior : ""
tag.components = components
tag.forceLabelOnNoChanges = forceLabel
tag.alternateView = alternateView
tag.label = label
tag.viewName = viewName
tag.viewPath = viewPath
tag.execute()
