import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.text.*
import groovy.xml.XmlUtil;

final def dateParser = new DateParser();
final def apTool = new AirPluginTool(this.args[0], this.args[1]);

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile


final String clearToolCommand = stepProps['source/repo/commandPath'] ?: 'cleartool'

final String srcName    = stepProps['source'];
final File dir          = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory
final String streamName = stepProps['source/streamName']
final String strategy          = stepProps['source/strategy']
final String loadRules  = stepProps['source/loadRules']
final String viewName   = stepProps['source/viewName']
final String viewPath   = stepProps['source/viewPath']

def userExcludesString  = stepProps['source/excludeUsers'] ?: ''
def fileFiltersString   = stepProps['source/fileFilters'] ?: '';

final String changesUrl = stepProps['changesUrl']

final def startRevision = stepProps['startRevision'] ?: ''
final def endRevision   = stepProps['endRevision'] ?: ''
final def startDate     = dateParser.parseDate(stepProps['startDate']) // explicit start date ?: startBuildLife.actualWorkspaceDate
final def endDate       = dateParser.parseDate(stepProps['endDate'])   // explicit end date ?: buildLife.actualWorkspaceDate

// create the directory ahead of time
dir.mkdirs()

// Execute
SCMChangelog changelog = new SCMChangelog()
changelog.scmCommand = clearToolCommand
changelog.directory = dir
changelog.streamName = streamName
changelog.strategy = strategy
changelog.startRevision = startRevision
changelog.endRevision = endRevision
changelog.startDate = startDate
changelog.endDate = endDate
changelog.changesUrl = changesUrl
changelog.loadRules = loadRules
changelog.viewName = viewName
changelog.viewPath = viewPath

changelog.userExcludes = userExcludesString
changelog.fileFilters = fileFiltersString

changelog.execute()
