/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.externalsort;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.externalsort.RecordReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
class RecordBuffer<T>
implements Closeable {
    private static final Logger log = Logger.getLogger(RecordBuffer.class);
    private final RecordReader<T> reader;
    private final ArrayList<T> buffer;
    private int maxRecords;
    private int bufferPosition;

    RecordBuffer(int maxRecords, RecordReader<T> reader) {
        if (maxRecords < 1) {
            throw new IllegalArgumentException();
        }
        this.maxRecords = maxRecords;
        this.reader = Check.nonNull(reader, "reader");
        this.buffer = new ArrayList(maxRecords);
        this.bufferPosition = maxRecords - 1;
    }

    public void setMaxRecords(int maxRecords) {
        if (maxRecords < 1) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resetting buffer size to " + maxRecords + " records"));
        }
        this.maxRecords = maxRecords;
    }

    public boolean moveNext() throws IOException {
        ++this.bufferPosition;
        if (this.bufferPosition >= this.buffer.size()) {
            T record;
            int count;
            this.buffer.clear();
            for (count = 0; count < this.maxRecords && (record = this.reader.read()) != null; ++count) {
                this.buffer.add(record);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read " + count + " records into buffer"));
            }
            this.bufferPosition = 0;
        }
        return this.buffer.size() > 0;
    }

    public T current() {
        if (this.buffer.size() == 0) {
            throw new IllegalStateException();
        }
        return this.buffer.get(this.bufferPosition);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.buffer.clear();
    }
}

