import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.util.Date;

final def workDir = new File('.').canonicalFile

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------
final def dateParser           = new DateParser();
final def apTool               = new AirPluginTool(this.args[0], this.args[1]);

final def stepProps            = apTool.getStepProperties();

final def clearToolCommand     = stepProps['source/repo/commandPath'] ?: 'cleartool'

final def srcName              = stepProps['source'];
final File dir                 = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory
final String vobName           = stepProps['source/vobName']
final String streamName        = stepProps['source/streamName']
final String strategy          = stepProps['source/strategy']
final String viewName          = stepProps['source/viewName']
final String viewPath          = stepProps['source/viewPath']
final boolean useTags          = Boolean.valueOf(stepProps['source/useTags'])
final String loadRules         = stepProps['source/loadRules']
final String hostStorPath      = stepProps['source/hostStorPath']
final String globStorPath      = stepProps['source/globStorPath']
final String hostname          = stepProps['source/hostname']
final boolean ptime            = Boolean.valueOf(stepProps['source/ptime'])
final String tmode             = stepProps['source/tmode']
final boolean checkoutWholeVob = Boolean.valueOf(stepProps['source/checkoutWholeVob'])

// look for date based checkout (buildlife, then actual workspace date)
final Date date                = dateParser.parseDate(stepProps['date']) // this is from actualWorkspaceDate
final Date blDate              = dateParser.parseDate(stepProps["buildlife/workspace.date.$srcName"]); // from checkout step

// look for revision from step (regular workspace date), then buildlife, then source config
final String revision          = stepProps['revision'];
final String blRevision        = stepProps["buildlife/workspace.revision.$srcName"];

// create the directory ahead of time
dir.mkdirs()

//
// Perform step
//
SCMCheckout co = new SCMCheckout();
co.scmCommand = clearToolCommand;
co.directory = dir
co.strategy = strategy
co.streamName = streamName
co.vobName = vobName
co.viewName = viewName
co.viewPath = viewPath
co.useTags = useTags
co.loadRules = loadRules
co.hostStorPath = hostStorPath
co.globStorPath = globStorPath
co.hostname = hostname
co.ptime = ptime
co.tmode = tmode
co.checkoutWholeVob = checkoutWholeVob
co.revision = revision ?: blRevision;
co.date = date ?: blDate
co.execute()

if (co.revision) {
    if (blRevision != co.revision) {
        println "Updating workspace revision on buildlife to $co.revision"
        apTool.setOutputProperty("buildlife/workspace.revision.$srcName", co.revision)
        println "";
    }
}
else if (co.date) {
    if (blDate != co.date) {
        println "Updating workspace date on buildlife to $co.date"
        apTool.setOutputProperty("buildlife/workspace.date.$srcName", String.valueOf(co.date))
        println "";
    }
}

apTool.storeOutputProperties()
