package com.urbancode.air.plugin.scm

public class SCMTag extends SCMStep {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    def message
    def labelBehavior
    def components
    boolean forceLabelOnNoChanges
    def alternateView
    def label

    public void execute() {
        setupWorkDir()
        
        def command = [scmCommand, "mkbl"]

        if (message) {
            command << "-c" << message
        }
        else {
            command << "-nc"
        }

        if (labelBehavior) {
            command << "-" + labelBehavior
        }

        if (components) {
            command << "-component" << components
        }

        if (forceLabelOnNoChanges) {
            command << "-identical"
        }

        if (alternateView) {
            command << "-view" << alternateView
        }

        command << label

        ch.runCommand("Applying label", command)
    }
}
