/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command;

import com.urbancode.air.plugin_command.Command;
import com.urbancode.air.plugin_command.Extensible;
import com.urbancode.air.plugin_command.Extension;
import com.urbancode.air.plugin_command.Utils;
import com.urbancode.air.plugin_command.properties.PluginCommandProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomationPlugin
implements Extensible {
    private String id;
    private String name;
    private long version;
    private String description;
    private String tag;
    private Map<String, Command> commands = new HashMap<String, Command>();
    private Extension extension;

    public AutomationPlugin(String id, String name, long version, String description, String tag) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.description = Utils.removeDuplicateWhitespace(description).trim();
        this.tag = tag;
    }

    public Command getCommandByName(String name) {
        Command result = this.commands.get(name);
        return result;
    }

    public void addCommand(Command command) {
        this.commands.put(command.getName(), command);
    }

    public Collection<Command> getCommands() {
        return this.commands.values();
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getExecuteCommand(String commandName) {
        Command command = this.getCommandByName(commandName);
        return command.getExecuteCommand();
    }

    public String getPostProcessingScript(String commandName) {
        Command command = this.getCommandByName(commandName);
        return command.getPostProcessingScript();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<PluginCommandProperty> getRequiredProperties(String commandName) {
        LinkedList<PluginCommandProperty> result = new LinkedList<PluginCommandProperty>();
        Command command = this.getCommandByName(commandName);
        for (PluginCommandProperty prop : command.getPluginProps()) {
            if (!prop.isRequired()) continue;
            result.add(prop);
        }
        return result;
    }

    public String getTag() {
        return this.tag;
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public Extension getExtension() {
        return this.extension;
    }

    @Override
    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public boolean hasCommand(String actionName) {
        return this.commands.containsKey(actionName);
    }

    public boolean apiEquals(AutomationPlugin that) {
        boolean result = this.id.equals(that.id);
        if (!result) {
            String oldThisId = this.id.replace(".air.", ".anthill3.");
            String oldThatId = that.id.replace(".air.", ".anthill3.");
            result = oldThisId.equals(oldThatId);
        }
        if (result && this.extension != null) {
            result = this.extension.apiEquals(that.extension);
        }
        if (result) {
            Set<String> thisCommandNames = this.commands.keySet();
            Set<String> thatCommandNames = that.commands.keySet();
            result = ((Object)thatCommandNames).equals(thisCommandNames);
        }
        for (Command thisCom : this.commands.values()) {
            if (!result) break;
            String name = thisCom.getName();
            Command thatCom = that.commands.get(name);
            result = thisCom.apiEquals(thatCom);
        }
        return result;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }
}

