/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.FileListerBase;
import com.urbancode.commons.fileutils.filelister.FileListerFactory;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.fileutils.filelister.PermissionReader;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

final class FileListerIncludeAllFollow
extends FileListerBase {
    static final FileListerFactory FACTORY = new FileListerFactory(){

        public FileListerIncludeAllFollow create(File base, FileFilter filter, PermissionReader permissionReader) throws IOException {
            return new FileListerIncludeAllFollow(base, filter, permissionReader);
        }

        public String implementationName() {
            return FileListerIncludeAllFollow.class.getName();
        }
    };

    FileListerIncludeAllFollow(File base, FileFilter filter, PermissionReader permissionReader) throws IOException {
        super(base, filter, permissionReader);
    }

    protected boolean includeInList(TypedFile file) {
        return file.translate(this.base()).exists();
    }

    protected TypedFile normalize(TypedFile file) throws IOException {
        if (file.type() == FileType.SYMLINK) {
            return TypedFile.createNoSymlinks(this.base(), file.path(), this.getPermissions(file));
        }
        return file;
    }

    boolean isSymLinkAware() {
        return false;
    }
}

