/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*

def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

def props = apTool.getStepProperties()

final def coverageReportName   = props['coverageReportName'] ? props['coverageReportName'] : 'Clover'
final def coverageXmlDirectory = new File(props['coverageXmlDirectory'] ?: '.')
final def buildLifeId = System.getenv('BUILD_LIFE_ID')

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------

try {
    def coverageXmlFile = new File(coverageXmlDirectory, "coverage.xml").canonicalFile

    if (coverageXmlFile.exists() && coverageXmlFile.isFile()) {
        println 'coverage.xml found: ' + coverageXmlFile.absolutePath
        def xmlHelper = new CloverCoverageXMLHelper()
        xmlHelper.uploadResult(coverageReportName, buildLifeId, coverageXmlFile)
    }
    else {
        println 'coverage.xml NOT found: ' + coverageXmlFile.absolutePath
        System.exit 1
     }
}
catch (e) {
    e.printStackTrace()
    System.exit 1
}

