/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.immutable;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.immutable.AImmutableMap;
import com.urbancode.commons.util.immutable.Box;
import com.urbancode.commons.util.immutable.IImmutableList;
import com.urbancode.commons.util.immutable.IImmutableMap;
import com.urbancode.commons.util.immutable.ISeq;
import com.urbancode.commons.util.immutable.ImmutableList;
import java.util.Comparator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class ImmutableTreeMap<K, V>
extends AImmutableMap<K, V> {
    public final Comparator<? super K> comp;
    public final Node<K, V> tree;
    public final int _count;
    private static final ImmutableTreeMap<?, ?> EMPTY = new ImmutableTreeMap();
    private static final Comparator<?> DEFAULT_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };

    private static <K> Comparator<K> defaultComparator() {
        return DEFAULT_COMPARATOR;
    }

    public static <K, V> ImmutableTreeMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> ImmutableTreeMap<K, V> empty(Comparator<? super K> comp) {
        if (comp != null) {
            return new ImmutableTreeMap<K, V>(comp);
        }
        return ImmutableTreeMap.empty();
    }

    public static <K, V> ImmutableTreeMap<K, V> create(Map<? extends K, ? extends V> other) {
        IImmutableMap<K, V> ret = ImmutableTreeMap.empty();
        for (Map.Entry<K, V> o : other.entrySet()) {
            ret = ret.with((Object)o.getKey(), (Object)o.getValue());
        }
        return ret;
    }

    ImmutableTreeMap() {
        this(ImmutableTreeMap.defaultComparator());
    }

    ImmutableTreeMap(Comparator<? super K> comp) {
        this.comp = comp;
        this.tree = null;
        this._count = 0;
    }

    ImmutableTreeMap(Comparator<? super K> comp, Node<K, V> tree, int _count) {
        this.comp = comp;
        this.tree = tree;
        this._count = _count;
    }

    @Override
    public V get(Object key, V notFound) {
        Map.Entry n = this.entryAt(key);
        return n != null ? ((Node)n).getValue() : notFound;
    }

    @Override
    public V get(Object key) {
        return this.get(key, null);
    }

    public K firstKey() {
        Node<K, V> t = this.min();
        return t != null ? (K)t.key : null;
    }

    public K lastKey() {
        Node<K, V> t = this.max();
        return t != null ? (K)t.key : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entryAt(key) != null;
    }

    @Override
    public ImmutableTreeMap<K, V> with(K key, V val) {
        Box found = new Box(null);
        Node<K, V> t = this.add(this.tree, key, val, found);
        if (t == null) {
            Node foundNode = (Node)found.val;
            if (foundNode.getValue() == val) {
                return this;
            }
            return new ImmutableTreeMap<K, V>(this.comp, this.replace(this.tree, key, val), this._count);
        }
        return new ImmutableTreeMap<K, V>(this.comp, t.blacken(), this._count + 1);
    }

    @Override
    public ImmutableTreeMap<K, V> without(Object key) {
        Box found = new Box(null);
        Node<Object, V> t = this.remove(this.tree, key, found);
        if (t == null) {
            if (found.val == null) {
                return this;
            }
            return new ImmutableTreeMap<K, V>(this.comp);
        }
        return new ImmutableTreeMap<Object, V>(this.comp, t.blacken(), this._count - 1);
    }

    @Override
    protected ISeq<Map.Entry<K, V>> seq() {
        if (this._count > 0) {
            return Seq.create(this.tree, true, this._count);
        }
        return null;
    }

    public Comparator<? super K> comparator() {
        return this.comp;
    }

    Node<K, V> min() {
        Node<K, V> t = this.tree;
        if (t != null) {
            while (t.left() != null) {
                t = t.left();
            }
        }
        return t;
    }

    Node<K, V> max() {
        Node<K, V> t = this.tree;
        if (t != null) {
            while (t.right() != null) {
                t = t.right();
            }
        }
        return t;
    }

    @Override
    public int size() {
        return this._count;
    }

    @Override
    public Node<K, V> entryAt(Object key) {
        Node<K, V> t = this.tree;
        while (t != null) {
            int c = this.compare(key, t.key);
            if (c == 0) {
                return t;
            }
            if (c < 0) {
                t = t.left();
                continue;
            }
            t = t.right();
        }
        return t;
    }

    private int compare(K k1, K k2) {
        return this.comp.compare(k1, k2);
    }

    Node<K, V> add(Node<K, V> t, K key, V val, Box found) {
        Node<K, V> ins;
        if (t == null) {
            if (val == null) {
                return new Red(key);
            }
            return new RedVal<K, V>(key, val);
        }
        int c = this.compare(key, t.key);
        if (c == 0) {
            found.val = t;
            return null;
        }
        Node<K, V> node = ins = c < 0 ? this.add(t.left(), key, val, found) : this.add(t.right(), key, val, found);
        if (ins == null) {
            return null;
        }
        if (c < 0) {
            return t.addLeft(ins);
        }
        return t.addRight(ins);
    }

    Node<K, V> remove(Node<K, V> t, K key, Box found) {
        Node<K, V> del;
        if (t == null) {
            return null;
        }
        int c = this.compare(key, t.key);
        if (c == 0) {
            found.val = t;
            return ImmutableTreeMap.append(t.left(), t.right());
        }
        Node<K, V> node = del = c < 0 ? this.remove(t.left(), key, found) : this.remove(t.right(), key, found);
        if (del == null && found.val == null) {
            return null;
        }
        if (c < 0) {
            if (t.left() instanceof Black) {
                return ImmutableTreeMap.balanceLeftDel(t.key, t.getValue(), del, t.right());
            }
            return ImmutableTreeMap.red(t.key, t.getValue(), del, t.right());
        }
        if (t.right() instanceof Black) {
            return ImmutableTreeMap.balanceRightDel(t.key, t.getValue(), t.left(), del);
        }
        return ImmutableTreeMap.red(t.key, t.getValue(), t.left(), del);
    }

    static <K, V> Node<K, V> append(Node<K, V> left, Node<K, V> right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left instanceof Red) {
            if (right instanceof Red) {
                Node<K, V> app = ImmutableTreeMap.append(left.right(), right.left());
                if (app instanceof Red) {
                    return ImmutableTreeMap.red(app.key, app.getValue(), ImmutableTreeMap.red(left.key, left.getValue(), left.left(), app.left()), ImmutableTreeMap.red(right.key, right.getValue(), app.right(), right.right()));
                }
                return ImmutableTreeMap.red(left.key, left.getValue(), left.left(), ImmutableTreeMap.red(right.key, right.getValue(), app, right.right()));
            }
            return ImmutableTreeMap.red(left.key, left.getValue(), left.left(), ImmutableTreeMap.append(left.right(), right));
        }
        if (right instanceof Red) {
            return ImmutableTreeMap.red(right.key, right.getValue(), ImmutableTreeMap.append(left, right.left()), right.right());
        }
        Node<K, V> app = ImmutableTreeMap.append(left.right(), right.left());
        if (app instanceof Red) {
            return ImmutableTreeMap.red(app.key, app.getValue(), ImmutableTreeMap.black(left.key, left.getValue(), left.left(), app.left()), ImmutableTreeMap.black(right.key, right.getValue(), app.right(), right.right()));
        }
        return ImmutableTreeMap.balanceLeftDel(left.key, left.getValue(), left.left(), ImmutableTreeMap.black(right.key, right.getValue(), app, right.right()));
    }

    static <K, V> Node<K, V> balanceLeftDel(K key, V val, Node<K, V> del, Node<K, V> right) {
        if (del instanceof Red) {
            return ImmutableTreeMap.red(key, val, del.blacken(), right);
        }
        if (right instanceof Black) {
            return ImmutableTreeMap.rightBalance(key, val, del, right.redden());
        }
        if (right instanceof Red && right.left() instanceof Black) {
            return ImmutableTreeMap.red(right.left().key, right.left().getValue(), ImmutableTreeMap.black(key, val, del, right.left().left()), ImmutableTreeMap.rightBalance(right.key, right.getValue(), right.left().right(), right.right().redden()));
        }
        throw new UnsupportedOperationException("Invariant violation");
    }

    static <K, V> Node<K, V> balanceRightDel(K key, V val, Node<K, V> left, Node<K, V> del) {
        if (del instanceof Red) {
            return ImmutableTreeMap.red(key, val, left, del.blacken());
        }
        if (left instanceof Black) {
            return ImmutableTreeMap.leftBalance(key, val, left.redden(), del);
        }
        if (left instanceof Red && left.right() instanceof Black) {
            return ImmutableTreeMap.red(left.right().key, left.right().getValue(), ImmutableTreeMap.leftBalance(left.key, left.getValue(), left.left().redden(), left.right().left()), ImmutableTreeMap.black(key, val, left.right().right(), del));
        }
        throw new UnsupportedOperationException("Invariant violation");
    }

    static <K, V> Node<K, V> leftBalance(K key, V val, Node<K, V> ins, Node<K, V> right) {
        if (ins instanceof Red && ins.left() instanceof Red) {
            return ImmutableTreeMap.red(ins.key, ins.getValue(), ins.left().blacken(), ImmutableTreeMap.black(key, val, ins.right(), right));
        }
        if (ins instanceof Red && ins.right() instanceof Red) {
            return ImmutableTreeMap.red(ins.right().key, ins.right().getValue(), ImmutableTreeMap.black(ins.key, ins.getValue(), ins.left(), ins.right().left()), ImmutableTreeMap.black(key, val, ins.right().right(), right));
        }
        return ImmutableTreeMap.black(key, val, ins, right);
    }

    static <K, V> Node<K, V> rightBalance(K key, V val, Node<K, V> left, Node<K, V> ins) {
        if (ins instanceof Red && ins.right() instanceof Red) {
            return ImmutableTreeMap.red(ins.key, ins.getValue(), ImmutableTreeMap.black(key, val, left, ins.left()), ins.right().blacken());
        }
        if (ins instanceof Red && ins.left() instanceof Red) {
            return ImmutableTreeMap.red(ins.left().key, ins.left().getValue(), ImmutableTreeMap.black(key, val, left, ins.left().left()), ImmutableTreeMap.black(ins.key, ins.getValue(), ins.left().right(), ins.right()));
        }
        return ImmutableTreeMap.black(key, val, left, ins);
    }

    Node<K, V> replace(Node<K, V> t, K key, V val) {
        int c = this.compare(key, t.key);
        return t.replace(t.key, c == 0 ? val : t.getValue(), c < 0 ? this.replace(t.left(), key, val) : t.left(), c > 0 ? this.replace(t.right(), key, val) : t.right());
    }

    static <K, V> Red<K, V> red(K key, V val, Node<K, V> left, Node<K, V> right) {
        if (left == null && right == null) {
            if (val == null) {
                return new Red(key);
            }
            return new RedVal<K, V>(key, val);
        }
        if (val == null) {
            return new RedBranch<K, V>(key, left, right);
        }
        return new RedBranchVal<K, V>(key, val, left, right);
    }

    static <K, V> Black<K, V> black(K key, V val, Node<K, V> left, Node<K, V> right) {
        if (left == null && right == null) {
            if (val == null) {
                return new Black(key);
            }
            return new BlackVal<K, V>(key, val);
        }
        if (val == null) {
            return new BlackBranch<K, V>(key, left, right);
        }
        return new BlackBranchVal<K, V>(key, val, left, right);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static class Seq<K, V>
    implements ISeq<Map.Entry<K, V>> {
        final IImmutableList<Map.Entry<K, V>> stack;
        final boolean asc;
        final int cnt;

        static <K, V> Seq<K, V> create(Node<K, V> t, boolean asc, int cnt) {
            return new Seq<K, V>(Seq.push(t, ImmutableList.<Map.Entry<K, V>>empty(), asc), asc, cnt);
        }

        static <K, V> IImmutableList<Map.Entry<K, V>> push(Node<K, V> t, IImmutableList<Map.Entry<K, V>> stack, boolean asc) {
            while (t != null) {
                if (stack == null) {
                    stack = ImmutableList.empty();
                }
                stack = stack.with(t);
                t = asc ? t.left() : t.right();
            }
            return stack;
        }

        Seq(IImmutableList<Map.Entry<K, V>> stack, boolean asc) {
            this.stack = stack;
            this.asc = asc;
            this.cnt = -1;
        }

        Seq(IImmutableList<Map.Entry<K, V>> stack, boolean asc, int cnt) {
            this.stack = stack;
            this.asc = asc;
            this.cnt = cnt;
        }

        @Override
        public Map.Entry<K, V> first() {
            return this.stack.first();
        }

        @Override
        public ISeq<Map.Entry<K, V>> next() {
            Node t = (Node)this.stack.first();
            IImmutableList nextstack = Seq.push(this.asc ? t.right() : t.left(), this.stack.rest(), this.asc);
            if (nextstack != null) {
                return new Seq(nextstack, this.asc, this.cnt - 1);
            }
            return null;
        }

        public int size() {
            return this.cnt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static class RedBranchVal<K, V>
    extends RedBranch<K, V> {
        final V val;

        public RedBranchVal(K key, V val, Node<K, V> left, Node<K, V> right) {
            super(key, left, right);
            this.val = val;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        Node<K, V> blacken() {
            return new BlackBranchVal<Object, V>(this.key, this.val, this.left, this.right);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static class RedBranch<K, V>
    extends Red<K, V> {
        final Node<K, V> left;
        final Node<K, V> right;

        public RedBranch(K key, Node<K, V> left, Node<K, V> right) {
            super(key);
            this.left = left;
            this.right = right;
        }

        @Override
        public Node<K, V> left() {
            return this.left;
        }

        @Override
        public Node<K, V> right() {
            return this.right;
        }

        @Override
        Node<K, V> balanceLeft(Node<K, V> parent) {
            if (this.left instanceof Red) {
                return ImmutableTreeMap.red(this.key, this.getValue(), this.left.blacken(), ImmutableTreeMap.black(parent.key, parent.getValue(), this.right, parent.right()));
            }
            if (this.right instanceof Red) {
                return ImmutableTreeMap.red(this.right.key, this.right.getValue(), ImmutableTreeMap.black(this.key, this.getValue(), this.left, this.right.left()), ImmutableTreeMap.black(parent.key, parent.getValue(), this.right.right(), parent.right()));
            }
            return super.balanceLeft(parent);
        }

        @Override
        Node<K, V> balanceRight(Node<K, V> parent) {
            if (this.right instanceof Red) {
                return ImmutableTreeMap.red(this.key, this.getValue(), ImmutableTreeMap.black(parent.key, parent.getValue(), parent.left(), this.left), this.right.blacken());
            }
            if (this.left instanceof Red) {
                return ImmutableTreeMap.red(this.left.key, this.left.getValue(), ImmutableTreeMap.black(parent.key, parent.getValue(), parent.left(), this.left.left()), ImmutableTreeMap.black(this.key, this.getValue(), this.left.right(), this.right));
            }
            return super.balanceRight(parent);
        }

        @Override
        Node<K, V> blacken() {
            return new BlackBranch<Object, V>(this.key, this.left, this.right);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static class RedVal<K, V>
    extends Red<K, V> {
        final V val;

        public RedVal(K key, V val) {
            super(key);
            this.val = val;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        Node<K, V> blacken() {
            return new BlackVal<Object, V>(this.key, this.val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static class Red<K, V>
    extends Node<K, V> {
        public Red(K key) {
            super(key);
        }

        @Override
        Node<K, V> addLeft(Node<K, V> ins) {
            return ImmutableTreeMap.red(this.key, this.getValue(), ins, this.right());
        }

        @Override
        Node<K, V> addRight(Node<K, V> ins) {
            return ImmutableTreeMap.red(this.key, this.getValue(), this.left(), ins);
        }

        @Override
        Node<K, V> removeLeft(Node<K, V> del) {
            return ImmutableTreeMap.red(this.key, this.getValue(), del, this.right());
        }

        @Override
        Node<K, V> removeRight(Node<K, V> del) {
            return ImmutableTreeMap.red(this.key, this.getValue(), this.left(), del);
        }

        @Override
        Node<K, V> blacken() {
            return new Black(this.key);
        }

        @Override
        Node<K, V> redden() {
            throw new UnsupportedOperationException("Invariant violation");
        }

        @Override
        Node<K, V> replace(K key, V val, Node<K, V> left, Node<K, V> right) {
            return ImmutableTreeMap.red(key, val, left, right);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static class BlackBranchVal<K, V>
    extends BlackBranch<K, V> {
        final V val;

        public BlackBranchVal(K key, V val, Node<K, V> left, Node<K, V> right) {
            super(key, left, right);
            this.val = val;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        Node<K, V> redden() {
            return new RedBranchVal<Object, V>(this.key, this.val, this.left, this.right);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static class BlackBranch<K, V>
    extends Black<K, V> {
        final Node<K, V> left;
        final Node<K, V> right;

        public BlackBranch(K key, Node<K, V> left, Node<K, V> right) {
            super(key);
            this.left = left;
            this.right = right;
        }

        @Override
        public Node<K, V> left() {
            return this.left;
        }

        @Override
        public Node<K, V> right() {
            return this.right;
        }

        @Override
        Node<K, V> redden() {
            return new RedBranch<Object, V>(this.key, this.left, this.right);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static class BlackVal<K, V>
    extends Black<K, V> {
        final V val;

        public BlackVal(K key, V val) {
            super(key);
            this.val = val;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        Node<K, V> redden() {
            return new RedVal<Object, V>(this.key, this.val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static class Black<K, V>
    extends Node<K, V> {
        public Black(K key) {
            super(key);
        }

        @Override
        Node<K, V> addLeft(Node<K, V> ins) {
            return ins.balanceLeft(this);
        }

        @Override
        Node<K, V> addRight(Node<K, V> ins) {
            return ins.balanceRight(this);
        }

        @Override
        Node<K, V> removeLeft(Node<K, V> del) {
            return ImmutableTreeMap.balanceLeftDel(this.key, this.getValue(), del, this.right());
        }

        @Override
        Node<K, V> removeRight(Node<K, V> del) {
            return ImmutableTreeMap.balanceRightDel(this.key, this.getValue(), this.left(), del);
        }

        @Override
        Node<K, V> blacken() {
            return this;
        }

        @Override
        Node<K, V> redden() {
            return new Red(this.key);
        }

        @Override
        Node<K, V> replace(K key, V val, Node<K, V> left, Node<K, V> right) {
            return ImmutableTreeMap.black(key, val, left, right);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static abstract class Node<K, V>
    implements Map.Entry<K, V> {
        final K key;

        Node(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return null;
        }

        Node<K, V> left() {
            return null;
        }

        Node<K, V> right() {
            return null;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        abstract Node<K, V> addLeft(Node<K, V> var1);

        abstract Node<K, V> addRight(Node<K, V> var1);

        abstract Node<K, V> removeLeft(Node<K, V> var1);

        abstract Node<K, V> removeRight(Node<K, V> var1);

        abstract Node<K, V> blacken();

        abstract Node<K, V> redden();

        Node<K, V> balanceLeft(Node<K, V> parent) {
            return ImmutableTreeMap.black(parent.key, parent.getValue(), this, parent.right());
        }

        Node<K, V> balanceRight(Node<K, V> parent) {
            return ImmutableTreeMap.black(parent.key, parent.getValue(), parent.left(), this);
        }

        abstract Node<K, V> replace(K var1, V var2, Node<K, V> var3, Node<K, V> var4);
    }
}

