/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.zipwriter;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.zipwriter.InfoZipUtil;
import com.urbancode.commons.util.zipwriter.ZipContentItemBase;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;

@BridgeMethodsAdded
public class ZipContentItemSymlink
extends ZipContentItemBase {
    private final String target;

    private static String normalizePath(String path) {
        if (path != null) {
            path = path.replace('\\', '/');
            path.replaceAll("/+", "/");
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
        }
        return path;
    }

    public ZipContentItemSymlink(String path, String target, long timestamp) {
        super(ZipContentItemSymlink.normalizePath(path), timestamp, Collections.emptySet());
        Check.nonNull(target);
        this.target = target.trim();
    }

    void writeContent(OutputStream stream) throws IOException {
        IO.writeText(stream, (CharSequence)this.target, IO.utf8());
    }

    InfoZipUtil.Type getType() {
        return InfoZipUtil.Type.SYMLINK;
    }
}

