import com.urbancode.air.*
import com.urbancode.air.plugin.quality.cobertura.CoberturaCoverageXMLHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

def props = apTool.getStepProperties()

final def coverageReportName   = props['coverageReportName'] ? props['coverageReportName'] : 'Cobertura'
final def coverageXmlDirectory = new File(props['coverageXmlDirectory'] ?: '.')
final def buildLifeId = System.getenv('BUILD_LIFE_ID')

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------

try {
    def coverageXmlFile = new File(coverageXmlDirectory, "coverage.xml").canonicalFile
    
    if (coverageXmlFile.exists() && coverageXmlFile.isFile()) {
        println 'coverage.xml found: ' + coverageXmlFile.absolutePath
        def xmlHelper = new CoberturaCoverageXMLHelper()
        xmlHelper.uploadResult(coverageReportName, buildLifeId, coverageXmlFile)
    }
    else {
        println 'coverage.xml NOT found: ' + coverageXmlFile.absolutePath
    }
}
catch (e) {
    e.printStackTrace()
    System.exit 1
}
