/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.query;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.query.QueryFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

@BridgeMethodsAdded
public class SimpleQueryFilter
extends QueryFilter
implements Serializable {
    private static final long serialVersionUID = 1L;

    public SimpleQueryFilter(String filterField, String filterType, String filterValue, int pageNumber, int rowsPerPage) {
        this(filterField, QueryFilter.FilterType.fromParamValue(filterType), filterValue, pageNumber, rowsPerPage);
    }

    public SimpleQueryFilter(String filterField, QueryFilter.FilterType filterType, String filterValue, int pageNumber, int rowsPerPage) {
        this.setPageNumber(pageNumber);
        this.setRowsPerPage(rowsPerPage);
        this.addFilter(filterField, filterType, filterValue);
        this.validate();
    }

    public boolean isDescending() {
        return false;
    }

    private void validate() {
        QueryFilter.Filter filter = this.getFilters().get(0);
        Check.nonNull(filter.getFieldName(), "filterField");
        Check.nonNull(filter.getFilterType(), "filterType");
        Check.nonNull(filter.getValues().get(0), "filterValue");
        if (this.getPageNumber() <= 0) {
            throw new IllegalArgumentException("Invalid page number.");
        }
        if (this.getRowsPerPage() <= 0) {
            throw new IllegalArgumentException("Invalid rows per page.");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.validate();
    }
}

