/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.ubuild.codestation.client.CommandLineParser;
import com.urbancode.ubuild.codestation.client.CommandLineRunner;
import com.urbancode.ubuild.codestation.client.ant.CodestationTask;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.ERROR);
        int result = 0;
        try {
            CommandLineParser parser = new CommandLineParser();
            CommandLine commandLine = parser.parse(args);
            try {
                if (commandLine.hasOption("v")) {
                    Logger.getRootLogger().setLevel(Level.INFO);
                }
                CommandLineRunner runner = new CommandLineRunner(commandLine);
                result = runner.run();
            }
            catch (Exception e) {
                if (commandLine.hasOption("v")) {
                    e.printStackTrace();
                }
                throw e;
            }
        }
        catch (NullPointerException npe) {
            System.err.println(npe.getClass().getSimpleName());
            result = 1;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            result = 1;
        }
        System.exit(result);
    }

    static {
        URL loggingPropsUrl = CodestationTask.class.getResource("/ucb-cs-log4j.properties");
        if (loggingPropsUrl != null) {
            PropertyConfigurator.configure((URL)loggingPropsUrl);
        }
    }
}

