/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.BuildLifeLookup;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.client.BuildProcessLookup;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import com.urbancode.ubuild.codestation.client.InvalidCommandLineException;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;

public class CommandLineRunner {
    private final CommandLine commandLine;

    public CommandLineRunner(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    public int run() throws Exception, InvalidCommandLineException {
        Object[] args = this.commandLine.getArgs();
        if (args == null || args.length == 0) {
            throw new InvalidCommandLineException("Expected a CodeStation action as a argument: dependencies, download, upload");
        }
        if (args.length > 1) {
            throw new InvalidCommandLineException("Expected a single CodeStation action to perform as a argument. Perhaps a option was specified incorrectly. Found arguments: " + Arrays.toString(args));
        }
        String command = args[0];
        String url = this.parseUrl();
        AuthenticationCredentials credentials = this.parseCredentials();
        CodestationClient client = new CodestationClient(url, credentials);
        if ("dependencies".equalsIgnoreCase(command)) {
            File destination = this.parseBaseDirectory();
            BuildProcess process = this.parseBuildProcess(client.getBuildProcessLookup());
            if (process != null) {
                client.downloadDependencies(process, destination);
            } else {
                BuildLife buildLife = this.parseBuildLife(client.getBuildLifeLookup());
                if (buildLife == null) {
                    throw new InvalidCommandLineException("Either a build config or a build life must be specified.");
                }
                client.downloadDependencies(buildLife, destination);
            }
        } else if ("download".equalsIgnoreCase(command)) {
            BuildLife buildLife = this.parseBuildLife(client.getBuildLifeLookup());
            String artifactSet = this.parseArtifactSet();
            File[] destinations = new File[]{this.parseBaseDirectory()};
            System.out.println("Downloading " + artifactSet + " of " + buildLife);
            client.downloadArtifacts(buildLife, artifactSet, destinations);
        } else if ("upload".equalsIgnoreCase(command)) {
            BuildLife buildLife = this.parseBuildLife(client.getBuildLifeLookup());
            String artifactSet = this.parseArtifactSet();
            File baseDirectory = this.parseBaseDirectory();
            client.uploadArtifactSet(buildLife, artifactSet, baseDirectory);
        } else if ("uploadAll".equalsIgnoreCase(command)) {
            BuildLife buildLife = this.parseBuildLife(client.getBuildLifeLookup());
            File baseDirectory = this.parseBaseDirectory();
            client.uploadAllArtifacts(buildLife, baseDirectory);
        } else {
            throw new InvalidCommandLineException("Unrecognized CodeStation action: " + command);
        }
        return 0;
    }

    private String parseArtifactSet() {
        return this.commandLine.getOptionValue("set");
    }

    private File parseBaseDirectory() {
        return new File(this.commandLine.getOptionValue("dir", "."));
    }

    private BuildProcess parseBuildProcess(BuildProcessLookup lookup) throws Exception {
        BuildProcess config = null;
        String projectId = this.commandLine.getOptionValue("project");
        String processId = this.commandLine.getOptionValue("build-process");
        if (projectId != null && processId != null) {
            config = lookup.findBuildProcess(projectId, processId);
        }
        return config;
    }

    private BuildLife parseBuildLife(BuildLifeLookup buildLifeLookup) throws Exception {
        BuildLife buildLife = this.parseBuildLifeById(buildLifeLookup);
        if (buildLife == null) {
            buildLife = this.parseCodestationBuildLifeById(buildLifeLookup);
        }
        if (buildLife == null) {
            buildLife = this.lookupBuildLife(buildLifeLookup);
        }
        if (buildLife == null) {
            // empty if block
        }
        return buildLife;
    }

    private BuildLife parseBuildLifeById(BuildLifeLookup buildLifeLookup) throws Exception {
        BuildLife buildLife = null;
        String buildLifeId = this.commandLine.getOptionValue("build-life");
        if (!StringUtils.isEmpty((String)buildLifeId)) {
            buildLife = buildLifeLookup.findBuildLife(buildLifeId);
        }
        return buildLife;
    }

    private BuildLife parseCodestationBuildLifeById(BuildLifeLookup buildLifeLookup) throws Exception {
        BuildLife codestationBuildLife = null;
        String codestationBuildLifeId = this.commandLine.getOptionValue("codestation-build-life");
        if (!StringUtils.isEmpty((String)codestationBuildLifeId)) {
            codestationBuildLife = buildLifeLookup.findCodestationBuildLife(codestationBuildLifeId);
        }
        return codestationBuildLife;
    }

    private BuildLife lookupBuildLife(BuildLifeLookup buildLifeLookup) throws Exception {
        BuildLife buildLife = null;
        String projectId = this.commandLine.getOptionValue("project");
        String processId = this.commandLine.getOptionValue("build-process");
        if (!StringUtils.isEmpty((String)projectId) && !StringUtils.isEmpty((String)processId)) {
            String stampPattern = this.commandLine.getOptionValue("stamp");
            String status = this.commandLine.getOptionValue("status");
            String label = this.commandLine.getOptionValue("label");
            buildLife = buildLifeLookup.findLatestBuildLife(projectId, processId, stampPattern, status, label);
        }
        return buildLife;
    }

    private String parseUrl() throws InvalidCommandLineException {
        String url = this.commandLine.getOptionValue("url");
        return url;
    }

    private AuthenticationCredentials parseCredentials() throws InvalidCommandLineException {
        AuthenticationCredentials credentials = null;
        String authToken = this.commandLine.getOptionValue("auth-token");
        String username = this.commandLine.getOptionValue("user");
        String password = this.commandLine.getOptionValue("password");
        if (!StringUtils.isEmpty((String)authToken)) {
            credentials = AuthenticationCredentials.createAuthTokenCredentials(authToken);
        } else if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
            credentials = AuthenticationCredentials.createUsernamePasswordCredentials(username, password);
        }
        return credentials;
    }
}

