/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import java.io.InputStream;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class BuildLifeLookup {
    private static final Logger log = Logger.getLogger(BuildLifeLookup.class);
    private final CodestationClient client;

    BuildLifeLookup(CodestationClient client) {
        this.client = client;
    }

    public BuildLife findBuildLife(String buildLifeId) throws Exception {
        String lookupUrl = UriBuilder.fromPath((String)this.client.getUrl()).path("build-lives").path(buildLifeId).build(new Object[0]).toString();
        return this.lookupBuildLife(lookupUrl);
    }

    public BuildLife findCodestationBuildLife(String codestationBuildLifeId) throws Exception {
        String lookupUrl = UriBuilder.fromPath((String)this.client.getUrl()).path("codestation").path("build-lives").path(codestationBuildLifeId).build(new Object[0]).toString();
        return this.lookupCodestationBuildLife(lookupUrl);
    }

    public BuildLife findLatestBuildLife(String projectId, String processId, String stampPattern, String status, String label) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.client.getUrl()).path("projects").path(projectId).path("buildProcesses").path(processId).path("buildLives").path("latest");
        if (!StringUtil.isEmpty((String)stampPattern)) {
            uriBuilder.queryParam("stamp", new Object[]{stampPattern});
        }
        if (!StringUtil.isEmpty((String)status)) {
            uriBuilder.queryParam("status", new Object[]{status});
        }
        if (!StringUtil.isEmpty((String)label)) {
            uriBuilder.queryParam("label", new Object[]{label});
        }
        String lookupUrl = uriBuilder.build(new Object[0]).toString();
        return this.lookupBuildLife(lookupUrl);
    }

    public BuildLife findLatestCodestationBuildLife(String codestationProjectId, String stampPattern, String status) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.client.getUrl()).path("codestation-projects").path(codestationProjectId).path("build-lives").path("latest");
        if (!StringUtil.isEmpty((String)stampPattern)) {
            uriBuilder.queryParam("stamp", new Object[]{stampPattern});
        }
        if (!StringUtil.isEmpty((String)status)) {
            uriBuilder.queryParam("status", new Object[]{status});
        }
        String lookupUrl = uriBuilder.build(new Object[0]).toString();
        return this.lookupCodestationBuildLife(lookupUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BuildLife lookupBuildLife(String lookupUrl) throws Exception {
        BuildLife buildLife = null;
        HttpGet method = this.client.createHttpGet(lookupUrl);
        try {
            HttpResponse response = this.client.executeHttpMethod((HttpRequestBase)method);
            int code = response.getStatusLine().getStatusCode();
            InputStream content = response.getEntity().getContent();
            switch (code) {
                case 200: {
                    String body = IO.readText((InputStream)content);
                    JSONObject json = new JSONObject(body);
                    String buildLifeId = json.getString("id");
                    String projectId = json.getString("projectId");
                    String processId = json.getString("buildConfigId");
                    String repositoryId = null;
                    JSONArray jsonProps = json.getJSONArray("properties");
                    for (int i = 0; i < jsonProps.length(); ++i) {
                        JSONObject jsonProp = jsonProps.getJSONObject(i);
                        if (!"codestation.repo.id".equals(jsonProp.getString("name"))) continue;
                        repositoryId = jsonProp.getString("value");
                        break;
                    }
                    buildLife = BuildLife.newBuildLife(this.client, buildLifeId, repositoryId, projectId, processId);
                    return buildLife;
                }
                case 204: 
                case 404: {
                    log.info((Object)"No build life found.");
                    return buildLife;
                }
                case 500: {
                    throw new Exception("Server error looking up build life: " + IO.readText((InputStream)content));
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code + " from " + lookupUrl);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BuildLife lookupCodestationBuildLife(String lookupUrl) throws Exception {
        BuildLife buildLife = null;
        HttpGet method = this.client.createHttpGet(lookupUrl);
        try {
            HttpResponse response = this.client.executeHttpMethod((HttpRequestBase)method);
            int code = response.getStatusLine().getStatusCode();
            InputStream content = response.getEntity().getContent();
            switch (code) {
                case 200: {
                    String body = IO.readText((InputStream)content);
                    JSONObject json = new JSONObject(body);
                    String codestationBuildLifeId = json.getString("id");
                    String codestationProjectId = json.getString("projectId");
                    String repositoryId = null;
                    JSONArray jsonProps = json.getJSONArray("properties");
                    for (int i = 0; i < jsonProps.length(); ++i) {
                        JSONObject jsonProp = jsonProps.getJSONObject(i);
                        if (!"codestation.repo.id".equals(jsonProp.getString("name"))) continue;
                        repositoryId = jsonProp.getString("value");
                        break;
                    }
                    buildLife = BuildLife.newCodestationBuildLife(this.client, codestationBuildLifeId, repositoryId, codestationProjectId);
                    return buildLife;
                }
                case 204: 
                case 404: {
                    log.info((Object)"No CodeStation build life found.");
                    return buildLife;
                }
                case 500: {
                    throw new Exception("Server error looking up CodeStation build life: " + IO.readText((InputStream)content));
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code + " from " + lookupUrl);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }
}

