/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.util.IO;
import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.BuildLifeLookup;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import java.io.InputStream;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

class RepositoryLookup {
    private static final Logger log = Logger.getLogger(BuildLifeLookup.class);
    private final CodestationClient client;

    RepositoryLookup(CodestationClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String findBuildLifeRepository(BuildLife buildLife) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.client.getUrl());
        if (buildLife.isCodestation()) {
            uriBuilder.path("build-lives").path(buildLife.getId());
        } else {
            uriBuilder.path("codestation-build-lives").path(buildLife.getId());
        }
        String findUrl = uriBuilder.build(new Object[0]).toString();
        String repositoryId = null;
        HttpGet method = this.client.createHttpGet(findUrl);
        try {
            HttpResponse response = this.client.executeHttpMethod((HttpRequestBase)method);
            int code = response.getStatusLine().getStatusCode();
            InputStream content = response.getEntity().getContent();
            switch (code) {
                case 200: {
                    String body = IO.readText((InputStream)content);
                    JSONObject json = new JSONObject(body);
                    JSONArray jsonProps = json.getJSONArray("properties");
                    for (int i = 0; i < jsonProps.length(); ++i) {
                        JSONObject jsonProp = jsonProps.getJSONObject(i);
                        if (!"codestation.repo.id".equals(jsonProp.getString("name"))) continue;
                        repositoryId = jsonProp.getString("value");
                        return repositoryId;
                    }
                    return repositoryId;
                }
                case 204: 
                case 404: {
                    log.info((Object)("No build life found for " + buildLife));
                    return repositoryId;
                }
                case 500: {
                    throw new Exception("Server error looking up build life: " + IO.readText((InputStream)content));
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }
}

