/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.ubuild.codestation.client.ArtifactUploadException;
import com.urbancode.ubuild.codestation.client.VfsClientFactory;
import com.urbancode.vfs.client.Client;
import com.urbancode.vfs.common.ClientChangeSet;
import com.urbancode.vfs.common.ClientPathEntry;
import com.urbancode.vfs.common.ClientRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NoHttpResponseException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArtifactUploader
extends VfsClientFactory {
    private static final Logger log = Logger.getLogger(ArtifactUploader.class);
    private static final int RETRY_COUNT = 5;
    private final Client client;
    private boolean failIfNotFound = false;

    ArtifactUploader(Client client) {
        this.client = client;
    }

    public void setFailIfNotFound(boolean failIfNotFound) {
        this.failIfNotFound = failIfNotFound;
    }

    void uploadArtifacts(String repoId, String artifactSet, File baseDirectory, String[] includes, String[] excludes, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions, FileListerBuilder.Symlinks symlinks, String hashAlgorithm, List<String> additionalDigestAlgorithms) throws ArtifactUploadException {
        this.uploadArtifacts(repoId, artifactSet, baseDirectory, includes, excludes, directories, permissions, symlinks, hashAlgorithm, additionalDigestAlgorithms, -1);
    }

    void uploadArtifacts(String repoId, String artifactSet, File baseDirectory, String[] includes, String[] excludes, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions, FileListerBuilder.Symlinks symlinks, String hashAlgorithm, List<String> additionalDigestAlgorithms, int requestTimeout) throws ArtifactUploadException {
        int numberOfTries = 0;
        int retriesLeft = 0;
        boolean successful = false;
        while (numberOfTries < 5 && !successful) {
            if (includes.length > 0) {
                try {
                    ClientRepository repo;
                    String latestChangeSetId;
                    retriesLeft = 5 - ++numberOfTries;
                    if (this.isUploadToSpecificPath(artifactSet)) {
                        artifactSet = this.formatArtifactPath(artifactSet);
                    }
                    ArrayList<String> hashAlgorithms = new ArrayList<String>();
                    hashAlgorithms.add(hashAlgorithm);
                    if (additionalDigestAlgorithms != null) {
                        hashAlgorithms.addAll(additionalDigestAlgorithms);
                    }
                    ClientChangeSet latestChangeSet = (latestChangeSetId = (repo = this.client.getRepository(repoId)).getLatestChangeSet()) != null ? this.client.getLatestChangeSet(repoId) : null;
                    log.info((Object)("Uploading artifacts from " + baseDirectory.getAbsolutePath()));
                    if (includes != null) {
                        log.info((Object)("Including [" + StringUtil.join((String[])includes, (String)", ") + "]"));
                    }
                    if (excludes != null) {
                        log.info((Object)("Excluding [" + StringUtil.join((String[])excludes, (String)", ") + "]"));
                    }
                    ClientPathEntry[] entries = ClientPathEntry.createPathEntriesFromFileSystemWithPrefix((File)baseDirectory, (String[])includes, (String[])excludes, (String)artifactSet, (FileListerBuilder.Directories)directories, (FileListerBuilder.Permissions)permissions, (FileListerBuilder.Symlinks)symlinks, (String[])hashAlgorithms.toArray(new String[0]));
                    if (this.failIfNotFound) {
                        String entry;
                        if (!baseDirectory.exists() || !baseDirectory.isDirectory()) {
                            throw new Exception("The directory containing the artifacts does not exist.");
                        }
                        if (entries.length == 1 && (entry = entries[0].getName() + "/").equals(artifactSet)) {
                            throw new Exception("There were no artifacts to upload.");
                        }
                    }
                    String stageId = this.client.createStagingDirectory();
                    try {
                        ClientChangeSet changeSet;
                        for (ClientPathEntry entry : entries) {
                            if (!FileType.REGULAR.equals((Object)entry.getType())) continue;
                            String filePath = entry.getPath();
                            if (this.isUploadToSpecificPath(artifactSet)) {
                                filePath = filePath.substring(artifactSet.length());
                            }
                            File entryFile = new File(baseDirectory, filePath);
                            log.info((Object)("Adding " + filePath + " for upload..."));
                            this.client.addFileToStagingDirectory(stageId, entry.getPath(), entryFile);
                        }
                        if (latestChangeSet == null) {
                            changeSet = ClientChangeSet.newChangeSet((String)repoId, (String)"codestation", (String)"", (ClientPathEntry[])entries);
                            log.debug((Object)"Creating first change set for repository...");
                        } else {
                            changeSet = latestChangeSet.addEntries("codestation", "", false, entries);
                            log.debug((Object)"Adding a new change set for repository...");
                        }
                        log.debug((Object)"Committing change set...");
                        String changeSetId = this.client.commitStagingDirectory(stageId, changeSet, requestTimeout);
                        log.debug((Object)("Created change set: " + changeSetId));
                        successful = true;
                        continue;
                    }
                    catch (Exception e) {
                        try {
                            this.client.deleteStagingDirectory(stageId, requestTimeout);
                        }
                        catch (Exception deleteException) {
                            if (deleteException.getMessage().contains("Transaction has been committed")) {
                                return;
                            }
                            log.warn((Object)("Error deleting staging directory " + stageId + ": " + deleteException.toString()));
                        }
                        throw e;
                    }
                }
                catch (Exception e) {
                    String message;
                    String detailedInformation = "repoId='" + repoId + "', baseDir='" + baseDirectory.getAbsolutePath() + "', artifactSet='" + artifactSet + "'";
                    if (numberOfTries >= 5) {
                        throw new ArtifactUploadException("Giving up artifact sets upload after 5 attempts: " + detailedInformation, e);
                    }
                    if (e instanceof NoHttpResponseException) {
                        message = "No http response to upload request: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                        log.warn((Object)message, (Throwable)e);
                        continue;
                    }
                    if (this.exceptionContainsString(e, "Connection Reset")) {
                        message = "Connection Reset during upload: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                        log.warn((Object)message, (Throwable)e);
                        continue;
                    }
                    if (this.exceptionContainsString(e, "Broken Pipe")) {
                        message = "Broken pipe during upload: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                        log.warn((Object)message, (Throwable)e);
                        continue;
                    }
                    if (this.exceptionContainsString(e, "write error")) {
                        message = "Write error during upload: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                        log.warn((Object)message, (Throwable)e);
                        continue;
                    }
                    if (this.exceptionContainsString(e, "read timed out")) {
                        message = "Read timed out during upload: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                        log.warn((Object)message, (Throwable)e);
                        continue;
                    }
                    throw new ArtifactUploadException("Unable to upload artifacts: " + detailedInformation + ": " + e.getMessage(), e);
                }
            }
            log.info((Object)"Includes list is empty. Nothing to upload.");
        }
    }

    private boolean isUploadToSpecificPath(String artifactSet) {
        return !StringUtil.isEmpty((String)artifactSet) && !".".equals(artifactSet);
    }

    private String formatArtifactPath(String artifactSet) {
        if (!(artifactSet = artifactSet.replace('\\', '/')).endsWith("/")) {
            artifactSet = artifactSet + "/";
        }
        return artifactSet;
    }

    private boolean exceptionContainsString(Throwable t, String searchStr) {
        while (t != null) {
            String message = t.getMessage();
            if (StringUtils.containsIgnoreCase((String)message, (String)searchStr)) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }
}

