#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2012, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

public class Helper {

    /**
     * This helper function is used throughout the Codestation plugin to parse the string value for additional hashes.
     * Historically, this value was saved as a comma-separated string in the old UI. Ever since UCB 6.1.3.2, the UI has
     * been re-written in JS and as a result, the value will be saved as a JSON array. Therefore, we can no longer just
     * tokenize the value based on ",". Due to the fact that we are still using the tokenize method with additional tokens,
     * the plugin will still be compatible with the old values.
     * @param str The string to convert to a list
     * @return List<String> containing each element of the tokenized string
     */
    List<String> convertToList(String str) {
        List<String> result = new ArrayList<String>();
        if (str) {
            List<String> tokenizedStr = str.tokenize("[\",]")
            for (String part : tokenizedStr) {
                if (part) {
                    result << part;
                }
            }
        }
        return result;
    }

}