/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CommandLineOptions
extends Options {
    private static final long serialVersionUID = 1L;
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String AUTH_TOKEN = "auth-token";
    public static final String BASE_DIR = "dir";
    public static final String BASE_DIR_SHORT = "d";
    public static final String ARTIFACT_SET = "set";
    public static final String DEP_FILE = "file";
    public static final String DEP_FILE_SHORT = "f";
    public static final String DEP_FILE_OUT = "out";
    public static final String DEP_FILE_OUT_SHORT = "o";
    public static final String TRUST_ALL_CERTS = "no-check-certificate";
    public static final String TRUST_ALL_CERTS_SHORT = "ncc";
    public static final String PROJECT = "project";
    public static final String PROJECT_SHORT = "p";
    public static final String BUILD_CONFIG = "build-config";
    public static final String BUILD_CONFIG_SHORT = "bc";
    public static final String CODESTATION_PROJECT = "codestation-project";
    public static final String CODESTATION_PROJECT_SHORT = "cs";
    public static final String BUILD_LIFE = "build-life";
    public static final String BUILD_LIFE_SHORT = "bl";
    public static final String CODESTATION_BUILD_LIFE = "codestation-build-life";
    public static final String CODESTATION_BUILD_LIFE_SHORT = "csbl";
    public static final String STAMP = "stamp";
    public static final String STATUS = "status";
    public static final String LABEL = "label";
    public static final String VERBOSE = "v";

    public CommandLineOptions() {
        this.configure();
    }

    private void configure() {
        this.addOption(new Option(null, URL, true, "The full URL of the Codestation server including protocol and port."));
        this.addOption(new Option(null, USER, true, "The username to login to the Codestation server with."));
        this.addOption(new Option(null, PASSWORD, true, "The password to login to the Codestation server with."));
        this.addOption(new Option(null, AUTH_TOKEN, true, "The authentication token to login to the Codestation server with."));
        this.addOption(new Option(BASE_DIR_SHORT, BASE_DIR, true, "The relative or absolute path to download or upload artifact from. If not specified, the current working directory is used."));
        this.addOption(new Option(null, ARTIFACT_SET, true, "The artifact set to download or upload."));
        this.addOption(new Option(DEP_FILE_SHORT, DEP_FILE, true, "The relative or absolute path to the dependencies file to use."));
        this.addOption(new Option(DEP_FILE_OUT_SHORT, DEP_FILE_OUT, true, "The relative or absolute path to write out a dependencies file to."));
        this.addOption(new Option(TRUST_ALL_CERTS_SHORT, TRUST_ALL_CERTS, false, "Trust any Codestation server certificate. Use if the Codestation server is using a self-signed certificate."));
        this.addOption(new Option(PROJECT_SHORT, PROJECT, true, "The project name or id."));
        this.addOption(new Option(BUILD_CONFIG_SHORT, BUILD_CONFIG, true, "The build configuration name or id of the project."));
        this.addOption(new Option(CODESTATION_PROJECT_SHORT, CODESTATION_PROJECT, true, "The Codestation project name or id."));
        this.addOption(new Option(BUILD_LIFE_SHORT, BUILD_LIFE, true, "The build life id."));
        this.addOption(new Option(null, STAMP, true, "The stamp pattern to match a build life. It can include * to match any number of characters or ? to match any one character."));
        this.addOption(new Option(null, STATUS, true, "The status name to match a build life."));
        this.addOption(new Option(null, LABEL, true, "The label name to match a build life."));
        this.addOption(new Option(null, VERBOSE, false, "Verbose output."));
    }
}

