/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.client;

import com.urbancode.commons.util.IO;
import com.urbancode.vfs.common.Hash;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.apache.commons.httpclient.methods.RequestEntity;

public class HashingInputStreamRequestEntity
implements RequestEntity {
    protected final InputStream input;
    protected final MessageDigest digest;
    protected final long length;

    HashingInputStreamRequestEntity(InputStream input, long length, MessageDigest digest) {
        this.input = input;
        this.digest = digest;
        this.length = length;
    }

    public void writeRequest(OutputStream output) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(output);
        dataOutput.writeLong(this.length);
        IO.copyAndDigest((InputStream)this.input, (OutputStream)dataOutput, (long)this.length, (MessageDigest[])new MessageDigest[]{this.digest});
        String hash = Hash.hashForMessageDigest(this.digest).toString();
        dataOutput.writeUTF(hash);
    }

    public long getContentLength() {
        return -1L;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public boolean isRepeatable() {
        return false;
    }
}

