/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.BuildLife;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class BuildLifeLookup {
    private static final Logger log = Logger.getLogger(BuildLifeLookup.class);
    private final String url;
    private final AuthenticationCredentials credentials;
    private final HttpClient httpClient;

    BuildLifeLookup(String url, AuthenticationCredentials credentials, HttpClient httpClient) {
        this.url = url;
        this.credentials = credentials;
        this.httpClient = httpClient;
    }

    public BuildLife findBuildLife(String buildLifeId) throws Exception {
        String lookupUrl = UriBuilder.fromPath((String)this.url).path("build-lives").path(buildLifeId).build(new Object[0]).toString();
        return this.lookupBuildLife(lookupUrl);
    }

    public BuildLife findCodestationBuildLife(String codestationBuildLifeId) throws Exception {
        String lookupUrl = UriBuilder.fromPath((String)this.url).path("codestation").path("build-lives").path(codestationBuildLifeId).build(new Object[0]).toString();
        return this.lookupCodestationBuildLife(lookupUrl);
    }

    public BuildLife findLatestBuildLife(String projectId, String processId, String stampPattern, String status, String label) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.url).path("projects").path(projectId).path("buildProcesses").path(processId).path("buildLives").path("latest");
        if (!StringUtil.isEmpty((String)stampPattern)) {
            uriBuilder.queryParam("stamp", new Object[]{stampPattern});
        }
        if (!StringUtil.isEmpty((String)status)) {
            uriBuilder.queryParam("status", new Object[]{status});
        }
        if (!StringUtil.isEmpty((String)label)) {
            uriBuilder.queryParam("label", new Object[]{label});
        }
        String lookupUrl = uriBuilder.build(new Object[0]).toString();
        return this.lookupBuildLife(lookupUrl);
    }

    public BuildLife findLatestCodestationBuildLife(String codestationProjectId, String stampPattern, String status) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.url).path("codestation-projects").path(codestationProjectId).path("build-lives").path("latest");
        if (!StringUtil.isEmpty((String)stampPattern)) {
            uriBuilder.queryParam("stamp", new Object[]{stampPattern});
        }
        if (!StringUtil.isEmpty((String)status)) {
            uriBuilder.queryParam("status", new Object[]{status});
        }
        String lookupUrl = uriBuilder.build(new Object[0]).toString();
        return this.lookupCodestationBuildLife(lookupUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BuildLife lookupBuildLife(String lookupUrl) throws Exception {
        BuildLife buildLife = null;
        GetMethod method = new GetMethod(lookupUrl);
        try {
            method.setFollowRedirects(false);
            if (this.credentials != null) {
                String authToken = this.credentials.getAuthToken();
                if (!StringUtil.isEmpty((String)authToken)) {
                    method.addRequestHeader("Authorization-Token", authToken);
                }
                String username = this.credentials.getUsername();
                String password = this.credentials.getPassword();
                if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                    HttpState httpState = this.httpClient.getState();
                    httpState.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                }
            }
            int code = this.httpClient.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    String body = method.getResponseBodyAsString();
                    JSONObject json = new JSONObject(body);
                    String buildLifeId = json.getString("id");
                    String projectId = json.getString("projectId");
                    String buildConfigId = json.getString("buildConfigId");
                    String repositoryId = null;
                    JSONArray jsonProps = json.getJSONArray("properties");
                    for (int i = 0; i < jsonProps.length(); ++i) {
                        JSONObject jsonProp = jsonProps.getJSONObject(i);
                        if (!"codestation.repo.id".equals(jsonProp.getString("name"))) continue;
                        repositoryId = jsonProp.getString("value");
                        break;
                    }
                    buildLife = BuildLife.newBuildLife(buildLifeId, repositoryId, projectId, buildConfigId);
                    return buildLife;
                }
                case 204: 
                case 404: {
                    log.info((Object)"No build life found.");
                    return buildLife;
                }
                case 500: {
                    throw new Exception("Server error looking up build life: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code + " from " + lookupUrl);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BuildLife lookupCodestationBuildLife(String lookupUrl) throws Exception {
        BuildLife buildLife = null;
        GetMethod method = new GetMethod(lookupUrl);
        try {
            method.setFollowRedirects(false);
            if (this.credentials != null) {
                String authToken = this.credentials.getAuthToken();
                if (!StringUtil.isEmpty((String)authToken)) {
                    method.addRequestHeader("Authorization-Token", authToken);
                }
                String username = this.credentials.getUsername();
                String password = this.credentials.getPassword();
                if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                    HttpState httpState = this.httpClient.getState();
                    httpState.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                }
            }
            int code = this.httpClient.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    String body = method.getResponseBodyAsString();
                    JSONObject json = new JSONObject(body);
                    String codestationBuildLifeId = json.getString("id");
                    String codestationProjectId = json.getString("projectId");
                    String repositoryId = null;
                    JSONArray jsonProps = json.getJSONArray("properties");
                    for (int i = 0; i < jsonProps.length(); ++i) {
                        JSONObject jsonProp = jsonProps.getJSONObject(i);
                        if (!"codestation.repo.id".equals(jsonProp.getString("name"))) continue;
                        repositoryId = jsonProp.getString("value");
                        break;
                    }
                    buildLife = BuildLife.newCodestationBuildLife(codestationBuildLifeId, repositoryId, codestationProjectId);
                    return buildLife;
                }
                case 204: 
                case 404: {
                    log.info((Object)"No CodeStation build life found.");
                    return buildLife;
                }
                case 500: {
                    throw new Exception("Server error looking up CodeStation build life: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code + " from " + lookupUrl);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }
}

