/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.ubuild.codestation.client.ArtifactDeliverPattern;
import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class BuildProcessLookup {
    private static final Logger log = Logger.getLogger(BuildProcessLookup.class);
    private final String url;
    private final AuthenticationCredentials credentials;
    private final HttpClient httpClient;

    BuildProcessLookup(String url, AuthenticationCredentials credentials, HttpClient httpClient) {
        this.url = url;
        this.credentials = credentials;
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BuildProcess findBuildConfig(String projectId, String processId) throws Exception {
        String findUrl = UriBuilder.fromPath((String)this.url).path("projects").path(projectId).path("buildProcesses").path(processId).build(new Object[0]).toString();
        BuildProcess process = null;
        GetMethod method = new GetMethod(findUrl);
        try {
            method.setFollowRedirects(false);
            if (this.credentials != null) {
                String authToken = this.credentials.getAuthToken();
                if (!StringUtil.isEmpty((String)authToken)) {
                    method.addRequestHeader("Authorization-Token", authToken);
                }
                String username = this.credentials.getUsername();
                String password = this.credentials.getPassword();
                if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                    HttpState httpState = this.httpClient.getState();
                    httpState.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                }
            }
            int code = this.httpClient.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    String body = method.getResponseBodyAsString();
                    JSONObject json = new JSONObject(body);
                    String realBuildProcessId = json.getString("id");
                    String realProjectId = json.getString("projectId");
                    JSONArray jsonArtifactPatterns = json.getJSONArray("artifactPatterns");
                    ArtifactDeliverPattern[] artifactPatterns = new ArtifactDeliverPattern[jsonArtifactPatterns.length()];
                    for (int i = 0; i < jsonArtifactPatterns.length(); ++i) {
                        JSONObject jsonArtifactPattern = jsonArtifactPatterns.getJSONObject(i);
                        String artifactSet = jsonArtifactPattern.getString("set");
                        String baseDirectory = jsonArtifactPattern.getString("dir");
                        JSONArray jsonIncludes = jsonArtifactPattern.getJSONArray("includes");
                        String[] includes = this.jsonArrayToStringArray(jsonIncludes);
                        JSONArray jsonExcludes = jsonArtifactPattern.getJSONArray("excludes");
                        String[] excludes = this.jsonArrayToStringArray(jsonExcludes);
                        artifactPatterns[i] = new ArtifactDeliverPattern(artifactSet, baseDirectory, includes, excludes);
                    }
                    process = new BuildProcess(realProjectId, realBuildProcessId, artifactPatterns);
                    return process;
                }
                case 204: {
                    log.info((Object)("No build life found for project and build process " + projectId + " - " + processId));
                    return process;
                }
                case 404: {
                    throw new Exception("Project or build process could not be found for " + projectId + " - " + processId);
                }
                case 500: {
                    throw new Exception("Server error looking up build life: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private String[] jsonArrayToStringArray(JSONArray jsonArray) throws JSONException {
        String[] stringArray = new String[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringArray[i] = jsonArray.getString(i);
        }
        return stringArray;
    }
}

