/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.BuildLifeLookup;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.xml.Dependencies;
import com.urbancode.ubuild.codestation.xml.Project;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class DependenciesLookup {
    private static final Logger log = Logger.getLogger(BuildLifeLookup.class);
    private final String url;
    private final AuthenticationCredentials credentials;
    private final HttpClient httpClient;

    DependenciesLookup(String url, AuthenticationCredentials credentials, HttpClient httpClient) {
        this.url = url;
        this.credentials = credentials;
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Dependencies findDependencies(BuildLife buildLife) throws Exception {
        String findUrl = UriBuilder.fromPath((String)this.url).path("build-lives").path(buildLife.getId()).path("dependencies-xml").build(new Object[0]).toString();
        Dependencies dependencies = null;
        GetMethod method = new GetMethod(findUrl);
        try {
            method.setFollowRedirects(false);
            if (this.credentials != null) {
                String authToken = this.credentials.getAuthToken();
                if (!StringUtil.isEmpty((String)authToken)) {
                    method.addRequestHeader("Authorization-Token", authToken);
                }
                String username = this.credentials.getUsername();
                String password = this.credentials.getPassword();
                if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                    HttpState httpState = this.httpClient.getState();
                    httpState.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                }
            }
            int code = this.httpClient.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    JAXBContext context = JAXBContext.newInstance((String)Project.class.getPackage().getName());
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    Project project = (Project)unmarshaller.unmarshal(method.getResponseBodyAsStream());
                    dependencies = project.getDependencies();
                    return dependencies;
                }
                case 204: 
                case 404: {
                    log.info((Object)("No dependencies found for build life " + buildLife.getId()));
                    return dependencies;
                }
                case 500: {
                    throw new Exception("Server error looking up build life dependencies: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Dependencies findDependencies(BuildProcess process) throws Exception {
        String findUrl = UriBuilder.fromPath((String)this.url).path("projects").path(process.getProjectId()).path("buildProcesses").path(process.getProcessId()).path("dependenciesXml").build(new Object[0]).toString();
        Dependencies dependencies = null;
        GetMethod method = new GetMethod(findUrl);
        try {
            method.setFollowRedirects(false);
            if (this.credentials != null) {
                String authToken = this.credentials.getAuthToken();
                if (!StringUtil.isEmpty((String)authToken)) {
                    method.addRequestHeader("Authorization-Token", authToken);
                }
                String username = this.credentials.getUsername();
                String password = this.credentials.getPassword();
                if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                    HttpState httpState = this.httpClient.getState();
                    httpState.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                }
            }
            int code = this.httpClient.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    JAXBContext context = JAXBContext.newInstance((String)Project.class.getPackage().getName());
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    Project project = (Project)unmarshaller.unmarshal(method.getResponseBodyAsStream());
                    dependencies = project.getDependencies();
                    return dependencies;
                }
                case 204: 
                case 404: {
                    log.info((Object)("No dependencies found for build process " + process.getProcessId()));
                    return dependencies;
                }
                case 500: {
                    throw new Exception("Server error looking up build process dependencies: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }
}

