/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlNsMap
implements NamespaceContext {
    private static final Logger log = Logger.getLogger(XmlNsMap.class);
    private final Map<String, String> prefix2namespace;
    private final Map<String, Set<String>> namespace2prefixes;

    public static XmlNsMap build(String ... prefixNamespacePairs) {
        Map<String, String> prefix2namespace;
        if (prefixNamespacePairs == null || prefixNamespacePairs.length == 0) {
            prefix2namespace = Collections.emptyMap();
        } else {
            if (prefixNamespacePairs.length % 2 != 0) {
                throw new IllegalArgumentException();
            }
            prefix2namespace = new HashMap<String, String>();
            for (int i = 1; i < prefixNamespacePairs.length; i += 2) {
                String prefix = prefixNamespacePairs[i - 1];
                String namespace = prefixNamespacePairs[i];
                if (prefix == null || namespace == null) {
                    throw new NullPointerException();
                }
                prefix2namespace.put(prefix, namespace);
            }
        }
        return new XmlNsMap(prefix2namespace);
    }

    static XmlNsMap build(Element scope) {
        if (scope == null) {
            throw new NullPointerException("scope");
        }
        HashMap<String, String> prefix2namespace = new HashMap<String, String>();
        while (true) {
            short type;
            String prefix = scope.getPrefix();
            String namespace = scope.getNamespaceURI();
            if (prefix == null) {
                prefix = "";
            }
            if (namespace == null) {
                namespace = "";
            }
            if (!prefix2namespace.containsKey(prefix)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding namespace {" + prefix + "}={" + namespace + "}"));
                }
                prefix2namespace.put(prefix, namespace);
            }
            NamedNodeMap attributes = scope.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                namespace = attribute.getNamespaceURI();
                if (log.isTraceEnabled()) {
                    String nl = System.getProperty("line.separator");
                    StringBuilder builder = new StringBuilder();
                    builder.append("Attribute:").append(nl);
                    builder.append("  NS: ").append(attribute.getNamespaceURI()).append(nl);
                    builder.append("  NN: ").append(attribute.getNodeName()).append(nl);
                    builder.append("  N: ").append(attribute.getName()).append(nl);
                    builder.append("  P: ").append(attribute.getPrefix()).append(nl);
                    builder.append("  LN: ").append(attribute.getLocalName()).append(nl);
                    builder.append("  C: ").append(attribute.getValue());
                    log.trace((Object)builder);
                }
                if ("http://www.w3.org/2000/xmlns/".equals(namespace)) {
                    prefix = attribute.getLocalName();
                    if ("xmlns".equals(prefix)) {
                        prefix = "";
                    }
                    namespace = attribute.getValue();
                } else {
                    prefix = attribute.getPrefix();
                }
                if (prefix == null) {
                    prefix = "";
                }
                if (namespace == null) {
                    namespace = "";
                }
                if (prefix2namespace.containsKey(prefix)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding namespace {" + prefix + "}={" + namespace + "}"));
                }
                prefix2namespace.put(prefix, namespace);
            }
            Node parent = scope.getParentNode();
            if (parent == null || (type = parent.getNodeType()) == 9 || type == 11) break;
            scope = (Element)parent;
        }
        return new XmlNsMap(prefix2namespace);
    }

    private XmlNsMap(Map<String, String> prefix2namespace) {
        if (prefix2namespace == null) {
            throw new NullPointerException("prefix2namespace");
        }
        this.prefix2namespace = prefix2namespace;
        if (this.prefix2namespace.containsKey(null)) {
            throw new IllegalArgumentException();
        }
        if (this.prefix2namespace.containsValue(null)) {
            throw new IllegalArgumentException();
        }
        this.prefix2namespace.remove("xml");
        this.prefix2namespace.remove("xmlns");
        if (this.prefix2namespace.containsValue("http://www.w3.org/XML/1998/namespace")) {
            throw new IllegalArgumentException();
        }
        if (this.prefix2namespace.containsValue("http://www.w3.org/2000/xmlns/")) {
            throw new IllegalArgumentException();
        }
        this.prefix2namespace.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.prefix2namespace.put("xmlns", "http://www.w3.org/2000/xmlns/");
        String defaultNamespace = this.prefix2namespace.get("");
        if (defaultNamespace == null) {
            this.prefix2namespace.put("", "");
        }
        this.namespace2prefixes = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> e : prefix2namespace.entrySet()) {
            String prefix = e.getKey();
            String namespace = e.getValue();
            Set<String> prefixes = this.namespace2prefixes.get(namespace);
            if (prefixes == null) {
                prefixes = new HashSet<String>();
                this.namespace2prefixes.put(namespace, prefixes);
            }
            prefixes.add(prefix);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        String result = this.prefix2namespace.get(prefix);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        Set<String> prefixes = this.namespace2prefixes.get(namespaceURI);
        String result = prefixes == null ? null : prefixes.iterator().next();
        return result;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        Set<String> prefixes = this.namespace2prefixes.get(namespaceURI);
        Iterator<Object> result = prefixes == null ? Collections.emptyList().iterator() : Collections.unmodifiableSet(prefixes).iterator();
        return result;
    }

    public String toString() {
        return this.prefix2namespace.toString();
    }
}

