/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.commons.util.IO;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;

public class FileTransferCodec {
    private static final int ok = 200;
    private static final int notFound = 404;
    private static byte[] okBytes;
    private static byte[] notFoundBytes;
    private static int colon;
    private static byte[] notFoundMessage;
    private static byte[] eol;

    public void encode(OutputStream out, InputStream in, long length) throws IOException {
        if (in != null) {
            out.write(okBytes);
            out.write(colon);
            out.write(this.lengthToBytes(length));
            out.write(eol);
            this.writeData(out, in, length);
            out.write(eol);
        } else {
            out.write(notFoundBytes);
            out.write(colon);
            out.write(this.lengthToBytes(notFoundMessage.length));
            out.write(eol);
            out.write(notFoundMessage);
            out.write(eol);
        }
    }

    public void decode(OutputStream out, InputStream in, MessageDigest digest) throws IOException {
        int code = this.readCode(in);
        long length = this.readLength(in);
        InputStream data = IO.limited((InputStream)in, (long)length);
        switch (code) {
            case 200: {
                break;
            }
            case 404: {
                String message = IO.readText((InputStream)data, (Charset)IO.utf8());
                this.readCr(in);
                this.readLf(in);
                throw new FileNotFoundException("Blob not found: " + message);
            }
            default: {
                IO.discard((InputStream)data);
                this.readCr(in);
                this.readLf(in);
                throw new IOException("Unexpected error code from server: " + code);
            }
        }
        if (digest != null) {
            IO.copyAndDigest((InputStream)data, (OutputStream)out, (MessageDigest[])new MessageDigest[]{digest});
        } else {
            IO.copy((InputStream)data, (OutputStream)out);
        }
        this.readCr(in);
        this.readLf(in);
    }

    private byte[] lengthToBytes(long length) throws UnsupportedEncodingException {
        return String.valueOf(length).getBytes("UTF-8");
    }

    private void writeData(OutputStream out, InputStream in, long length) throws IOException {
        int count;
        byte[] buffer = new byte[65536];
        while ((count = this.readUptoLength(in, buffer, length)) != -1) {
            out.write(buffer, 0, count);
            length -= (long)count;
        }
        if (length > 0L) {
            throw new IOException("File ended prematurely: expected " + length + " more bytes");
        }
    }

    private int readUptoLength(InputStream in, byte[] buffer, long maxLength) throws IOException {
        int result = -1;
        if (maxLength > 0L) {
            int count = (int)Math.min((long)buffer.length, maxLength);
            result = in.read(buffer, 0, count);
        }
        return result;
    }

    private int readCode(InputStream in) throws IOException {
        int b;
        int max = 64;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int count = 0;
        while ((b = this.readByte(in)) != 58) {
            out.write(b);
            if (++count <= max) continue;
            throw new IOException("Invalid stream: code field too long");
        }
        return this.parseInt(out.toByteArray());
    }

    private int parseInt(byte[] data) throws IOException {
        int result;
        String text = new String(data, "UTF-8");
        try {
            result = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid int string");
        }
        return result;
    }

    private long readLength(InputStream in) throws IOException {
        int b;
        int max = 64;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int count = 0;
        while ((b = this.readByte(in)) != 13) {
            out.write(b);
            if (++count <= max) continue;
            throw new IOException("Invalid stream: length field too long");
        }
        this.readLf(in);
        return this.parseLong(out.toByteArray());
    }

    private long parseLong(byte[] data) throws IOException {
        long result;
        String text = new String(data, "UTF-8");
        try {
            result = Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid long string");
        }
        return result;
    }

    private void readLf(InputStream in) throws IOException {
        int b = this.readByte(in);
        if (b != 10) {
            throw new IOException("Missing line-feed");
        }
    }

    private void readCr(InputStream in) throws IOException {
        int b = this.readByte(in);
        if (b != 13) {
            throw new IOException("Missing carriage-return");
        }
    }

    private int readByte(InputStream in) throws IOException {
        int result = in.read();
        if (result == -1) {
            throw new EOFException("Premature end of data");
        }
        return result;
    }

    static {
        colon = 58;
        try {
            okBytes = String.valueOf(200).getBytes("UTF-8");
            notFoundBytes = String.valueOf(404).getBytes("UTF-8");
            notFoundMessage = "Not found".getBytes("UTF-8");
            eol = "\r\n".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not available.");
        }
    }
}

