/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.https.OpenSSLProtocolSocketFactory;
import com.urbancode.ubuild.codestation.client.ArtifactDeliverPattern;
import com.urbancode.ubuild.codestation.client.ArtifactDownloadException;
import com.urbancode.ubuild.codestation.client.ArtifactDownloader;
import com.urbancode.ubuild.codestation.client.ArtifactSetNotFoundException;
import com.urbancode.ubuild.codestation.client.ArtifactUploadException;
import com.urbancode.ubuild.codestation.client.ArtifactUploader;
import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.BuildLifeLookup;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.client.BuildProcessLookup;
import com.urbancode.ubuild.codestation.client.DependenciesLookup;
import com.urbancode.ubuild.codestation.client.UrlMaker;
import com.urbancode.ubuild.codestation.client.util.CodestationProperties;
import com.urbancode.ubuild.codestation.xml.Dependencies;
import com.urbancode.ubuild.codestation.xml.Dependency;
import com.urbancode.ubuild.codestation.xml.DependencyDelivery;
import com.urbancode.vfs.client.Client;
import com.urbancode.vfs.client.cache.Cache;
import com.urbancode.vfs.common.ClientChangeSet;
import com.urbancode.vfs.common.ClientPathEntry;
import com.urbancode.vfs.common.ClientRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodestationClient {
    private final String url;
    private final AuthenticationCredentials credentials;
    private final Client vfsClient;
    private final HttpClient httpClient;
    private FileListerBuilder.Directories directories = FileListerBuilder.Directories.INCLUDE_ALL;
    private FileListerBuilder.Permissions permissions = FileListerBuilder.Permissions.NONE;
    private FileListerBuilder.Symlinks symlinks = FileListerBuilder.Symlinks.AS_LINK;
    private String hashAlgorithm = "SHA-256";
    private List<String> additionalDigestAlgorithms = new ArrayList<String>();
    private CodestationProperties codestationProperties;

    public CodestationClient(String url, AuthenticationCredentials authCredentials, HttpClient httpClient) {
        this.url = new UrlMaker().makeCodestationBaseUrl(url);
        this.httpClient = httpClient;
        this.codestationProperties = new CodestationProperties();
        Properties properties = new Properties();
        properties.put("codestation.server", url);
        if (authCredentials != null) {
            if (authCredentials.getUsername() != null) {
                properties.put("codestation.user", authCredentials.getUsername());
                properties.put("codestation.password", authCredentials.getPassword());
            } else if (authCredentials.getAuthToken() != null) {
                properties.put("codestation.authToken", authCredentials.getAuthToken());
            }
        }
        this.codestationProperties.configure(properties);
        this.credentials = this.codestationProperties.getCredentials();
        String proxyHost = System.getProperty("http.proxyHost");
        if (!StringUtil.isEmpty((String)proxyHost)) {
            Integer proxyPort = Integer.valueOf(System.getProperty("http.proxyPort"));
            httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort.intValue());
            this.vfsClient = new Client(this.url, proxyHost, proxyPort);
        } else {
            this.vfsClient = new Client(this.url);
        }
        OpenSSLProtocolSocketFactory socketFactory = new OpenSSLProtocolSocketFactory();
        Protocol https = new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
        Protocol.registerProtocol((String)"https", (Protocol)https);
        if (this.credentials != null) {
            if (!StringUtil.isEmpty((String)this.credentials.getAuthToken())) {
                this.vfsClient.setRequestHeader("Authorization-Token", this.credentials.getAuthToken());
            }
            if (!StringUtil.isEmpty((String)this.credentials.getUsername()) && !StringUtil.isEmpty((String)this.credentials.getPassword())) {
                this.vfsClient.setBasicAuthCredentials(this.credentials.getUsername(), this.credentials.getPassword());
            }
        }
    }

    public void addAdditionalDigestAlgorithm(String digestAlgorithm) {
        if (!"SHA-256".equalsIgnoreCase(digestAlgorithm)) {
            this.additionalDigestAlgorithms.add(digestAlgorithm);
        }
    }

    public List<String> getAdditionalDigestAlgorithms() {
        return new ArrayList<String>(this.additionalDigestAlgorithms);
    }

    public BuildProcessLookup getBuildProcessLookup() {
        return new BuildProcessLookup(this.url, this.credentials, this.httpClient);
    }

    public BuildLifeLookup getBuildLifeLookup() {
        return new BuildLifeLookup(this.url, this.credentials, this.httpClient);
    }

    public List<File> downloadDependencies(BuildLife buildLife, File destination) throws ArtifactDownloadException {
        DependenciesLookup lookup = new DependenciesLookup(this.url, this.credentials, this.httpClient);
        Dependencies dependencies = null;
        try {
            dependencies = lookup.findDependencies(buildLife);
        }
        catch (Exception e) {
            throw new ArtifactDownloadException("Error downloading the build life's dependencies.", e);
        }
        return this.downloadDependencies(dependencies, destination);
    }

    public List<File> downloadDependencies(BuildLife buildLife, File dependenciesXml, File destination) throws ArtifactDownloadException {
        DependenciesLookup lookup = new DependenciesLookup(this.url, this.credentials, this.httpClient);
        Dependencies dependencies = null;
        try {
            dependencies = lookup.findDependencies(buildLife, dependenciesXml);
        }
        catch (Exception e) {
            throw new ArtifactDownloadException("Error downloading the build life's dependencies.", e);
        }
        return this.downloadDependencies(dependencies, destination);
    }

    public List<File> downloadDependencies(BuildProcess process, File dependenciesXml, File destination) throws ArtifactDownloadException {
        DependenciesLookup lookup = new DependenciesLookup(this.url, this.credentials, this.httpClient);
        Dependencies dependencies = null;
        try {
            dependencies = lookup.findDependencies(process, dependenciesXml);
        }
        catch (Exception e) {
            throw new ArtifactDownloadException("Error downloading the build life's dependencies.", e);
        }
        return this.downloadDependencies(dependencies, destination);
    }

    public List<File> downloadDependencies(BuildProcess config, File destination) throws ArtifactDownloadException {
        DependenciesLookup lookup = new DependenciesLookup(this.url, this.credentials, this.httpClient);
        Dependencies dependencies = null;
        try {
            dependencies = lookup.findDependencies(config);
        }
        catch (Exception e) {
            throw new ArtifactDownloadException("Error determining dependencies.", e);
        }
        return this.downloadDependencies(dependencies, destination);
    }

    public List<File> downloadArtifacts(BuildLife buildLife, String artifactSet, File ... destinations) throws ArtifactDownloadException {
        String repoId = buildLife.getRepositoryId();
        ArtifactDownloader downloader = new ArtifactDownloader(this.vfsClient);
        return downloader.downloadArtifacts(repoId, artifactSet, null, null, destinations);
    }

    public void uploadAllArtifacts(BuildLife buildLife, File baseDirectory) throws ArtifactUploadException, ArtifactSetNotFoundException {
        BuildProcess process;
        try {
            process = buildLife.lookupBuildProcess(this.url, this.credentials, this.httpClient);
        }
        catch (Exception e) {
            throw new ArtifactUploadException("Error loading the build configuration for the build life.", e);
        }
        for (ArtifactDeliverPattern artifactDeliver : process.getArtifactDeliverPatterns()) {
            this.uploadArtifacts(buildLife, artifactDeliver, baseDirectory);
        }
    }

    public void uploadArtifactSet(BuildLife buildLife, String artifactSet, File baseDirectory) throws ArtifactUploadException, ArtifactSetNotFoundException {
        BuildProcess process;
        try {
            process = buildLife.lookupBuildProcess(this.url, this.credentials, this.httpClient);
        }
        catch (Exception e) {
            throw new ArtifactUploadException("Error loading the build configuration for the build life.", e);
        }
        boolean artifactSetFound = false;
        for (ArtifactDeliverPattern artifactDeliver : process.getArtifactDeliverPatterns()) {
            if (!StringUtil.isEmpty((String)artifactSet) && !artifactSet.equals(artifactDeliver.getArtifactSet())) continue;
            artifactSetFound = true;
            this.uploadArtifacts(buildLife, artifactDeliver, baseDirectory);
        }
        if (!artifactSetFound) {
            throw new ArtifactSetNotFoundException("No artifact delivery configuration for artifact set '" + artifactSet + "' was found.");
        }
    }

    private List<File> downloadDependencies(Dependencies dependencies, File destination) throws ArtifactDownloadException {
        ArrayList<File> downloadedFiles = new ArrayList<File>();
        for (Dependency dependency : dependencies.getDependency()) {
            BuildLife depBuildLife = BuildLife.fromDependency(dependency);
            for (DependencyDelivery delivery : dependency.getDelivery()) {
                String artifactSet = delivery.getArtifactSet();
                for (String directory : delivery.getDirectory()) {
                    File downloadDir = new File(destination, directory);
                    downloadedFiles.addAll(this.downloadArtifacts(depBuildLife, artifactSet, downloadDir));
                }
            }
        }
        return downloadedFiles;
    }

    private void uploadArtifacts(BuildLife buildLife, ArtifactDeliverPattern artifactDeliver, File baseDirectory) throws ArtifactUploadException {
        String repoId = buildLife.getRepositoryId();
        ArtifactUploader uploader = new ArtifactUploader(this.vfsClient);
        File artifactDeliverDirectory = new File(baseDirectory, artifactDeliver.getBaseDirectory());
        uploader.uploadArtifacts(repoId, artifactDeliver.getArtifactSet(), artifactDeliverDirectory, artifactDeliver.getIncludes(), artifactDeliver.getExcludes(), this.directories, this.permissions, this.symlinks, this.hashAlgorithm, this.getAdditionalDigestAlgorithms());
    }

    public void setCacheDir(File cacheDir) throws IOException {
        this.vfsClient.setCache(new Cache(cacheDir));
    }

    public void setSymlinks(FileListerBuilder.Symlinks symlinks) {
        this.symlinks = symlinks;
    }

    public void setDirectories(FileListerBuilder.Directories directories) {
        this.directories = directories;
    }

    public void setPermissions(FileListerBuilder.Permissions permissions) {
        this.permissions = permissions;
    }

    public void uploadArtifactSet(BuildLife buildLife, String artifactSet, File baseDirectory, FileListerBuilder.Symlinks symlinks, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions) throws ArtifactUploadException, ArtifactSetNotFoundException {
        this.setSymlinks(symlinks);
        this.setDirectories(directories);
        this.setPermissions(permissions);
        this.uploadArtifactSet(buildLife, artifactSet, baseDirectory);
    }

    public void uploadAllArtifacts(BuildLife buildLife, File baseDirectory, FileListerBuilder.Symlinks symlinks, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions) throws ArtifactUploadException, ArtifactSetNotFoundException {
        this.setSymlinks(symlinks);
        this.setDirectories(directories);
        this.setPermissions(permissions);
        this.uploadAllArtifacts(buildLife, baseDirectory);
    }

    public void copyAllArtifacts(BuildLife buildLife, String targetUrl, String repositoryId, String username, String password, Map<String, String> requestHeaders, String label) throws ArtifactUploadException {
        try {
            this.vfsClient.copyChangeSet(buildLife.getRepositoryId(), "latest", targetUrl, repositoryId, username, password, requestHeaders, label);
        }
        catch (Exception e) {
            throw new ArtifactUploadException("Error copying artifacts sets to " + targetUrl, e);
        }
    }

    public void setExecuteBitsOnly(boolean setExecuteBitsOnly) {
        this.vfsClient.setSetFileExecuteBitsOnly(setExecuteBitsOnly);
    }

    public void setSetPermissions(boolean setPermissions) {
        this.vfsClient.setSetPermissions(setPermissions);
    }

    public List<String> getPublishedArtifactSets(String buildLifeId) throws Exception {
        BuildLife buildLife = this.getBuildLifeLookup().findBuildLife(buildLifeId);
        ArrayList<String> setList = new ArrayList<String>();
        String repositoryId = buildLife.getRepositoryId();
        ClientRepository repository = this.vfsClient.getRepository(repositoryId);
        if (repository != null) {
            HashSet<String> artifactSetSet = new HashSet<String>();
            String changeSetId = repository.getLatestChangeSet();
            ClientChangeSet changeSet = this.vfsClient.getChangeSet(repositoryId, changeSetId);
            if (changeSet != null) {
                for (ClientPathEntry entry : changeSet.getEntries()) {
                    int sepIndex = entry.getPath().indexOf("/");
                    if (sepIndex <= 0) continue;
                    String artifactSet = entry.getPath().substring(0, sepIndex);
                    artifactSetSet.add(artifactSet);
                }
            }
            setList.addAll(artifactSetSet);
            Collections.sort(setList);
        }
        return setList;
    }
}

