/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.client;

import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.https.OpenSSLProtocolSocketFactory;
import com.urbancode.vfs.client.EntryFilePair;
import com.urbancode.vfs.client.HashingInputStreamRequestEntity;
import com.urbancode.vfs.client.PatternPathFilter;
import com.urbancode.vfs.client.cache.Cache;
import com.urbancode.vfs.client.cache.CacheStagingFile;
import com.urbancode.vfs.common.ClientChangeSet;
import com.urbancode.vfs.common.ClientChangeSetDelta;
import com.urbancode.vfs.common.ClientPathEntry;
import com.urbancode.vfs.common.ClientRepository;
import com.urbancode.vfs.common.FileMetadataHelper;
import com.urbancode.vfs.common.FileTransferCodec;
import com.urbancode.vfs.common.Hash;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    private static Logger log = Logger.getLogger(Client.class);
    private final String baseUrl;
    final HttpClient client;
    private boolean setPermissions;
    private boolean setFileExecuteBitsOnly;
    private boolean verifyFileIntegrity;
    private boolean useCompression;
    private Cache cache;
    private FileMetadataHelper metadataHelper;
    private Map<String, String> requestHeaders;
    private String basicAuthUser;
    private String basicAuthPassword;
    private List<String> additionalDigestAlgorithms;

    public Client(String baseUrl) {
        this(baseUrl, null, null);
    }

    public Client(String baseUrl, String proxyHost, Integer proxyPort) {
        this.metadataHelper = new FileMetadataHelper(this.setPermissions, this.setFileExecuteBitsOnly);
        this.requestHeaders = new HashMap<String, String>();
        this.baseUrl = baseUrl;
        this.client = new HttpClient();
        if (!StringUtil.isEmpty((String)proxyHost) && proxyPort != null) {
            this.client.getHostConfiguration().setProxy(proxyHost, proxyPort.intValue());
        }
        OpenSSLProtocolSocketFactory socketFactory = new OpenSSLProtocolSocketFactory();
        Protocol https = new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
        Protocol.registerProtocol((String)"https", (Protocol)https);
    }

    public void setRequestHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    public void setBasicAuthCredentials(String user, String password) {
        this.basicAuthUser = user;
        this.basicAuthPassword = password;
    }

    public boolean isSetPermissions() {
        return this.setPermissions;
    }

    public void setSetPermissions(boolean setPermissions) {
        this.setPermissions = setPermissions;
        this.metadataHelper = new FileMetadataHelper(setPermissions, this.setFileExecuteBitsOnly);
    }

    public boolean isSetFileExecuteBitsOnly() {
        return this.setFileExecuteBitsOnly;
    }

    public void setSetFileExecuteBitsOnly(boolean setFileExecuteBitsOnly) {
        this.setFileExecuteBitsOnly = setFileExecuteBitsOnly;
        this.metadataHelper = new FileMetadataHelper(this.setPermissions, setFileExecuteBitsOnly);
    }

    public void addAdditionalDigestAlgorithm(String digestAlgorithm) {
        if (!"SHA-256".equalsIgnoreCase(digestAlgorithm)) {
            this.additionalDigestAlgorithms.add(digestAlgorithm);
        }
    }

    public List<String> getAdditionalDigestAlgorithms() {
        return new ArrayList<String>(this.additionalDigestAlgorithms);
    }

    public boolean isVerifyFileIntegrity() {
        return this.verifyFileIntegrity;
    }

    public void setVerifyFileIntegrity(boolean verifyFileIntegrity) {
        this.verifyFileIntegrity = verifyFileIntegrity;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompress) {
        this.useCompression = useCompress;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String copyChangeSet(String sourceRepoId, String sourceChangeSetId, String targetUrl, String targetRepoId, String username, String password, Map<String, String> requestHeaders, String label) throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("repo").path(sourceRepoId).path(sourceChangeSetId).path("copyToServer").build(new Object[0]).toString();
        String changeSetId = null;
        PostMethod method = new PostMethod(url);
        try {
            method.setFollowRedirects(false);
            this.addHeaders((HttpMethod)method);
            JSONObject json = new JSONObject();
            json.put("url", (Object)targetUrl);
            json.put("repo", (Object)targetRepoId);
            json.put("label", (Object)label);
            json.put("username", (Object)username);
            json.put("password", (Object)password);
            JSONObject jsonHeaders = null;
            if (requestHeaders != null && !requestHeaders.isEmpty()) {
                jsonHeaders = new JSONObject();
                for (Map.Entry<String, String> headerEntry : requestHeaders.entrySet()) {
                    jsonHeaders.put(headerEntry.getKey(), (Object)headerEntry.getValue());
                }
            }
            json.put("headers", jsonHeaders);
            StringRequestEntity entity = new StringRequestEntity(json.toString(), "application/json", IO.utf8().name());
            method.setRequestEntity((RequestEntity)entity);
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 201: {
                    URL changeSetUrl = new URL(method.getResponseHeader("Location").getValue());
                    log.debug((Object)("ChangeSet copied to: " + changeSetUrl));
                    changeSetId = this.getLastPathOfURL(changeSetUrl);
                    return changeSetId;
                }
                case 500: {
                    throw new Exception("Server error creating repository: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void downloadFile(String hash, File file) throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("file").path(hash).build(new Object[0]).toString();
        GetMethod method = new GetMethod(url);
        try {
            method.setFollowRedirects(false);
            this.addHeaders((HttpMethod)method);
            log.debug((Object)("Downloading " + hash + " to " + file));
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    InputStream input = method.getResponseBodyAsStream();
                    file.getParentFile().mkdirs();
                    if (this.verifyFileIntegrity) {
                        MessageDigest digest = MessageDigest.getInstance("SHA-256");
                        IO.copyAndDigest((InputStream)input, (File)file, (MessageDigest[])new MessageDigest[]{digest});
                        String downloadedHash = Hash.hashForMessageDigest(digest).toString();
                        if (!hash.equals(downloadedHash)) {
                            try {
                                IO.delete((File)file);
                                throw new Exception("Requested hash " + hash + " does not match computed download hash " + downloadedHash);
                            }
                            catch (IOException e) {
                                log.error((Object)("Error deleting downloaded file '" + file.getAbsolutePath() + "' whose hash did not validate."));
                            }
                            throw new Exception("Requested hash " + hash + " does not match computed download hash " + downloadedHash);
                        }
                        log.debug((Object)("Verified " + hash));
                        return;
                    }
                    IO.copy((InputStream)input, (File)file);
                    return;
                }
                case 404: {
                    throw new Exception("File not found for hash: " + hash);
                }
                case 500: {
                    throw new Exception("Server error retrieving change set: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void downloadPathEntry(ClientPathEntry entry, File file) throws Exception {
        if (!entry.getType().equals((Object)FileType.REGULAR)) {
            throw new Exception("Only regular file entries may be downloaded.");
        }
        if (entry.getContentHash() == null) {
            throw new Exception("Only entries with content hash values may be downloaded.");
        }
        this.downloadFile(entry.getContentHash().toString(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createRepository() throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("repo").build(new Object[0]).toString();
        String repoId = null;
        PostMethod method = new PostMethod(url);
        try {
            method.setFollowRedirects(false);
            this.addHeaders((HttpMethod)method);
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 201: {
                    URL repoUrl = new URL(method.getResponseHeader("Location").getValue());
                    log.debug((Object)("Repository created: " + repoUrl));
                    repoId = this.getLastPathOfURL(repoUrl);
                    return repoId;
                }
                case 500: {
                    throw new Exception("Server error creating repository: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClientRepository getRepository(String repoId) throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("repo").path(repoId).build(new Object[0]).toString();
        ClientRepository repository = null;
        GetMethod method = new GetMethod(url);
        try {
            method.setFollowRedirects(false);
            this.addHeaders((HttpMethod)method);
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    String body = method.getResponseBodyAsString();
                    JSONObject json = new JSONObject(body);
                    repository = ClientRepository.fromJSON(json);
                    return repository;
                }
                case 404: {
                    throw new Exception("Repository not found: " + url);
                }
                case 500: {
                    throw new Exception("Server error retrieving repository: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public ClientChangeSet getLatestChangeSet(String repoId) throws Exception {
        return this.getChangeSet(repoId, "HEAD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClientChangeSet getChangeSet(String repoId, String changeSetId) throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("repo").path(repoId).path(changeSetId).build(new Object[0]).toString();
        ClientChangeSet changeSet = null;
        GetMethod method = new GetMethod(url);
        try {
            method.setFollowRedirects(false);
            this.addHeaders((HttpMethod)method);
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    String body = method.getResponseBodyAsString();
                    JSONObject json = new JSONObject(body);
                    changeSet = ClientChangeSet.fromJSON(json);
                    return changeSet;
                }
                case 404: {
                    throw new Exception("Repository or change set not found: " + url);
                }
                case 500: {
                    throw new Exception("Server error retrieving change set: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void labelChangeSet(String repoId, String changeSetId, String label, String user, String comment) throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("repo").path(repoId).path(changeSetId).path("label").path(label).build(new Object[0]).toString();
        PostMethod method = new PostMethod(url);
        try {
            method.setFollowRedirects(false);
            method.addParameter("user", user);
            method.addParameter("comment", comment);
            this.addHeaders((HttpMethod)method);
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    return;
                }
                case 404: {
                    throw new Exception("Change set not found to label: " + changeSetId);
                }
                case 500: {
                    throw new Exception("Server error retrieving change set: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClientChangeSet getChangeSetByLabel(String repoId, String label) throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("repo").path(repoId).path("byLabel").path(label).build(new Object[0]).toString();
        ClientChangeSet changeSet = null;
        GetMethod method = new GetMethod(url);
        try {
            method.setFollowRedirects(false);
            this.addHeaders((HttpMethod)method);
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    String body = method.getResponseBodyAsString();
                    JSONObject json = new JSONObject(body);
                    changeSet = ClientChangeSet.fromJSON(json);
                    return changeSet;
                }
                case 404: {
                    throw new Exception("Repository or change set not found by label: repo - " + repoId + ", label - " + label);
                }
                case 500: {
                    throw new Exception("Server error retrieving change set: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void downloadChangeSetFilesByLabel(String repoId, String label, File directory, String[] includes, String[] excludes) throws Exception {
        ClientChangeSet changeSet = this.getChangeSetByLabel(repoId, label);
        ClientPathEntry[] entries = changeSet.getEntries();
        this.downloadFilesInternal(entries, directory, includes, excludes);
    }

    public void downloadChangeSetFilesByLabel(String repoId, String label, File directory) throws Exception {
        ClientChangeSet changeSet = this.getChangeSetByLabel(repoId, label);
        ArrayList<EntryFilePair> entryFilePairs = new ArrayList<EntryFilePair>();
        for (ClientPathEntry entry : changeSet.getEntries()) {
            File file = new File(directory, entry.getPath());
            this.analyzeFileType(entry, file, entryFilePairs, entry.getPath());
        }
        this.transferFiles(directory, entryFilePairs);
    }

    public List<File> downloadLatestChangeSetFiles(String repoId, File directory) throws Exception {
        return this.downloadChangeSetFiles(repoId, "HEAD", directory);
    }

    public List<File> downloadLatestChangeSetFiles(String repoId, File directory, String[] includes, String[] excludes) throws Exception {
        return this.downloadChangeSetFiles(repoId, "HEAD", directory, includes, excludes);
    }

    public List<File> downloadLatestChangeSetFilesRemovingPrefix(String repoId, File directory, String[] includes, String[] excludes, String pathPrefix) throws Exception {
        return this.downloadChangeSetFilesRemovingPrefix(repoId, "HEAD", directory, includes, excludes, pathPrefix);
    }

    public List<File> downloadChangeSetFiles(String repoId, String changeSetId, File directory, String[] includes, String[] excludes) throws Exception {
        return this.downloadChangeSetFilesRemovingPrefix(repoId, changeSetId, directory, includes, excludes, null);
    }

    public List<File> downloadChangeSetFiles(String repoId, String changeSetId, File directory) throws Exception {
        return this.downloadChangeSetFilesRemovingPrefix(repoId, changeSetId, directory, null, null, null);
    }

    public List<File> downloadChangeSetFilesRemovingPrefix(String repoId, String changeSetId, File directory, String[] includes, String[] excludes, String pathToRemove) throws Exception {
        ArrayList<File> downloadedFiles = new ArrayList<File>();
        ClientChangeSet changeSet = this.getChangeSet(repoId, changeSetId);
        Object[] entries = changeSet.getEntries();
        Arrays.sort(entries);
        ArrayList<EntryFilePair> entryFilePairs = new ArrayList<EntryFilePair>();
        includes = this.processIncludesWithPathToRemove(pathToRemove, includes);
        excludes = this.processFiltersWithPathToRemove(pathToRemove, excludes);
        PatternPathFilter pathFilter = new PatternPathFilter(includes, excludes);
        for (Object entry : entries) {
            String path = ((ClientPathEntry)entry).getPath();
            if (pathFilter.includes(path)) {
                if (pathToRemove != null) {
                    path = path.substring(pathToRemove.length());
                }
                File file = new File(directory, path);
                downloadedFiles.add(file);
                this.analyzeFileType((ClientPathEntry)entry, file, entryFilePairs, path);
                continue;
            }
            log.info((Object)("Excluding '" + path + "'"));
        }
        this.transferFiles(directory, entryFilePairs);
        return downloadedFiles;
    }

    public List<File> downloadChangeSetFilesByLabelRemovingPathPrefix(String repoId, String label, File directory, String[] includes, String[] excludes, String pathToRemove) throws Exception {
        ArrayList<File> downloadedFiles = new ArrayList<File>();
        ClientChangeSet changeSet = this.getChangeSetByLabel(repoId, label);
        Object[] entries = changeSet.getEntries();
        Arrays.sort(entries);
        ArrayList<EntryFilePair> entryFilePairs = new ArrayList<EntryFilePair>();
        includes = this.processIncludesWithPathToRemove(pathToRemove, includes);
        excludes = this.processFiltersWithPathToRemove(pathToRemove, excludes);
        PatternPathFilter pathFilter = new PatternPathFilter(includes, excludes);
        for (Object entry : entries) {
            String path = ((ClientPathEntry)entry).getPath();
            if (pathFilter.includes(path)) {
                if (pathToRemove != null) {
                    path = path.substring(pathToRemove.length());
                }
                File file = new File(directory, path);
                downloadedFiles.add(file);
                this.analyzeFileType((ClientPathEntry)entry, file, entryFilePairs, path);
                continue;
            }
            log.info((Object)("Excluding '" + path + "'"));
        }
        this.transferFiles(directory, entryFilePairs);
        return downloadedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createStagingDirectory() throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("stage").build(new Object[0]).toString();
        String stageId = null;
        PostMethod method = new PostMethod(url);
        try {
            method.setFollowRedirects(false);
            this.addHeaders((HttpMethod)method);
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 201: {
                    URL stageUrl = new URL(method.getResponseHeader("Location").getValue());
                    log.debug((Object)("Staging directory created: " + stageUrl));
                    stageId = this.getLastPathOfURL(stageUrl);
                    return stageId;
                }
                case 500: {
                    throw new Exception("Server error creating staging directory: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToStagingDirectory(String stageId, String path, File file) throws Exception {
        if (file.isFile()) {
            FileInputStream input = new FileInputStream(file);
            try {
                this.addFileToStagingDirectory(stageId, path, input, file.length());
            }
            finally {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteStagingDirectory(String stageId) throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("stage").path(stageId).build(new Object[0]).toString();
        DeleteMethod method = new DeleteMethod(url);
        try {
            method.setFollowRedirects(false);
            this.addHeaders((HttpMethod)method);
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    log.debug((Object)("Staging directory deleted: " + url));
                    return;
                }
                case 404: {
                    log.warn((Object)("Staging directory not found to delete: " + stageId));
                    return;
                }
                case 500: {
                    throw new Exception("Server error deleting staging directory: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String commitStagingDirectory(String stageId, ClientChangeSet changeSet) throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("stage").path(stageId).build(new Object[0]).toString();
        String hash = null;
        PutMethod method = new PutMethod(url);
        try {
            method.setFollowRedirects(false);
            String json = changeSet.toJSON().toString();
            StringRequestEntity inputEntity = new StringRequestEntity(json, "application/json", "UTF-8");
            method.setRequestEntity((RequestEntity)inputEntity);
            this.addHeaders((HttpMethod)method);
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 201: {
                    URL changeSetUrl = new URL(method.getResponseHeader("Location").getValue());
                    log.debug((Object)("Created repository change set: " + changeSetUrl));
                    hash = this.getLastPathOfURL(changeSetUrl);
                    return hash;
                }
                case 404: {
                    throw new Exception("Staging directory not found to add path to: " + stageId);
                }
                case 500: {
                    throw new Exception("Server error adding path to staging directory: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addFileToStagingDirectory(String stageId, String path, InputStream input, long length) throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("stage").path(stageId).path(path).build(new Object[0]).toString();
        PutMethod method = new PutMethod(url);
        try {
            method.setFollowRedirects(false);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            HashingInputStreamRequestEntity inputEntity = new HashingInputStreamRequestEntity(input, length, digest);
            method.setRequestEntity((RequestEntity)inputEntity);
            this.addHeaders((HttpMethod)method);
            int code = this.client.executeMethod((HttpMethod)method);
            switch (code) {
                case 201: {
                    String stagedPathUrl = method.getResponseHeader("Location").getValue();
                    log.debug((Object)("Added path to staging directory: " + stagedPathUrl));
                    return;
                }
                case 404: {
                    throw new Exception("Staging directory not found to add path to: " + stageId);
                }
                case 500: {
                    throw new Exception("Server error adding path to staging directory: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private String getLastPathOfURL(URL url) {
        return url.getPath().substring(url.getPath().lastIndexOf("/") + 1);
    }

    public void downloadChangeSetDelta(ClientChangeSetDelta changeSetDelta, File directory, String[] includes, String[] excludes) throws Exception {
        this.downloadChangeSetDeltaRemovingPathPrefix(changeSetDelta, directory, includes, excludes, null);
    }

    public void downloadChangeSetDeltaRemovingPathPrefix(ClientChangeSetDelta changeSetDelta, File directory, String[] includes, String[] excludes, String pathPrefix) throws Exception {
        ClientPathEntry[] entries = changeSetDelta.getEntries();
        this.downloadFilesInternalRemovingPathPrefix(entries, directory, includes, excludes, pathPrefix);
    }

    private void downloadFilesInternal(ClientPathEntry[] entries, File directory, String[] includes, String[] excludes) throws Exception {
        this.downloadFilesInternalRemovingPathPrefix(entries, directory, includes, excludes, null);
    }

    private void downloadFilesInternalRemovingPathPrefix(ClientPathEntry[] entries, File directory, String[] includes, String[] excludes, String pathToRemove) throws Exception {
        Arrays.sort(entries);
        PatternPathFilter pathFilter = new PatternPathFilter(includes, excludes);
        ArrayList<EntryFilePair> entryFilePairs = new ArrayList<EntryFilePair>();
        for (ClientPathEntry entry : entries) {
            String path = entry.getPath();
            includes = this.processIncludesWithPathToRemove(pathToRemove, includes);
            excludes = this.processFiltersWithPathToRemove(pathToRemove, excludes);
            if (pathFilter.includes(path)) {
                if (pathToRemove != null) {
                    path = path.substring(pathToRemove.length());
                }
                File file = new File(directory, path);
                this.analyzeFileType(entry, file, entryFilePairs, path);
                continue;
            }
            log.info((Object)("Excluding '" + path + "'"));
        }
        this.transferFiles(directory, entryFilePairs);
    }

    private void analyzeFileType(ClientPathEntry entry, File file, List<EntryFilePair> entryFilePairs, String path) {
        if (FileType.REGULAR.equals((Object)entry.getType())) {
            entryFilePairs.add(new EntryFilePair(entry, file));
        } else if (FileType.DIRECTORY.equals((Object)entry.getType())) {
            log.info((Object)("Creating directory '" + path + "'"));
            file.mkdirs();
            this.metadataHelper.applyEntryMetadata(entry, file);
            this.metadataHelper.applyEntryPermissions(entry, file);
        } else if (FileType.SYMLINK.equals((Object)entry.getType())) {
            log.info((Object)("Creating symlink '" + path + "' to '" + entry.getLinkPath() + "'"));
            try {
                this.metadataHelper.createSymlink(file, entry.getLinkPath());
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred creating the symlink at '" + file + "'", e);
            }
            this.metadataHelper.applyEntryMetadata(entry, file);
            this.metadataHelper.applyEntryPermissions(entry, file);
        } else {
            log.warn((Object)("Not downloading unrecognized file type of '" + entry.getType() + "' at '" + entry.getPath() + "'"));
        }
    }

    private String[] processIncludesWithPathToRemove(String pathToRemove, String[] includes) {
        if (includes == null || includes.length == 0) {
            includes = new String[]{"**/*"};
        }
        return this.processFiltersWithPathToRemove(pathToRemove, includes);
    }

    private String[] processFiltersWithPathToRemove(String pathToRemove, String[] filters) {
        if (!StringUtil.isEmpty((String)pathToRemove)) {
            pathToRemove.replace('\\', '/');
            if (!pathToRemove.endsWith("/")) {
                pathToRemove = pathToRemove + "/";
            }
            while (pathToRemove.startsWith("/")) {
                pathToRemove = pathToRemove.substring(1);
            }
            if (filters != null && filters.length > 0) {
                for (int includesIndex = 0; includesIndex < filters.length; ++includesIndex) {
                    filters[includesIndex] = pathToRemove + filters[includesIndex];
                }
            }
        }
        return filters;
    }

    private void transferFiles(File target, Collection<EntryFilePair> hashFilePairs) throws Exception {
        if (this.cache != null) {
            Collection<EntryFilePair> uncached = this.getUncachedFiles(hashFilePairs);
            this.downloadFiles(uncached, new CacheDownloadHandler());
            this.copyCachedFiles(target, hashFilePairs);
        } else {
            this.downloadFiles(hashFilePairs, new DirectDownloadHandler());
        }
    }

    private Collection<EntryFilePair> getUncachedFiles(Collection<EntryFilePair> hashFilePairs) {
        ArrayList<EntryFilePair> uncached = new ArrayList<EntryFilePair>();
        for (EntryFilePair pair : hashFilePairs) {
            byte[] hash = pair.getEntry().getContentHash().getBytes();
            if (this.cache.isCached(hash)) continue;
            uncached.add(pair);
        }
        return uncached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCachedFiles(File target, Collection<EntryFilePair> hashFilePairs) throws Exception {
        for (EntryFilePair pair : hashFilePairs) {
            File file = pair.getFile();
            log.info((Object)("Copying file '" + file + "'"));
            byte[] hash = pair.getEntry().getContentHash().getBytes();
            InputStream in = this.cache.get(hash);
            if (in == null) {
                throw new IOException("Cache modified while in use");
            }
            try {
                IO.mkdirs((File)file.getParentFile());
                file.delete();
                try {
                    IO.copy((InputStream)in, (File)file);
                }
                catch (IOException e) {
                    file.delete();
                    throw e;
                }
                this.applyMetadata(pair.getEntry(), file);
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void downloadFiles(Collection<EntryFilePair> hashFilePairs, DownloadHandler handler) throws Exception {
        String url = UriBuilder.fromPath((String)this.baseUrl).path("files").build(new Object[0]).toString();
        JSONArray hashes = new JSONArray();
        for (EntryFilePair pair : hashFilePairs) {
            hashes.put((Object)pair.getEntry().getContentHash());
        }
        String json = hashes.toString();
        PostMethod method = new PostMethod(url);
        method.addRequestHeader("Accept", "application/x-urbancode.vfs.v1");
        if (this.useCompression) {
            method.addRequestHeader("Accept-Encoding", "gzip");
        }
        this.addHeaders((HttpMethod)method);
        StringRequestEntity entity = new StringRequestEntity(json, "application/json", IO.utf8().name());
        method.setRequestEntity((RequestEntity)entity);
        int code = this.client.executeMethod((HttpMethod)method);
        try {
            boolean gzip = false;
            Header contentEncoding = method.getResponseHeader("Content-Encoding");
            if (contentEncoding != null) {
                String value = contentEncoding.getValue();
                gzip = value != null && value.indexOf("gzip") != -1;
            }
            switch (code) {
                case 200: {
                    boolean successful = false;
                    InputStream in = method.getResponseBodyAsStream();
                    if (gzip) {
                        in = new GZIPInputStream(in);
                    }
                    try {
                        for (EntryFilePair pair : hashFilePairs) {
                            handler.download(in, pair);
                        }
                        successful = true;
                        IO.closeSafely((Closeable)in, (!successful ? 1 : 0) != 0);
                    }
                    catch (IOException e) {
                        try {
                            method.abort();
                            throw e;
                        }
                        catch (Throwable throwable) {
                            IO.closeSafely((Closeable)in, (!successful ? 1 : 0) != 0);
                            throw throwable;
                        }
                    }
                    return;
                }
                case 404: {
                    throw new Exception("Service not found at " + url);
                }
                case 500: {
                    throw new Exception("Server error retrieving change set: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code + ": " + method.getResponseBodyAsString());
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private void applyMetadata(ClientPathEntry entry, File file) {
        this.metadataHelper.applyEntryMetadata(entry, file);
        this.metadataHelper.applyEntryPermissions(entry, file);
    }

    private void copyFileFromDownload(InputStream in, OutputStream out, ClientPathEntry entry) throws IOException {
        Hash actualHash;
        Hash expectedHash;
        FileTransferCodec codec = new FileTransferCodec();
        MessageDigest digest = null;
        if (this.verifyFileIntegrity) {
            digest = IO.sha256Digester();
        }
        try {
            codec.decode(out, in, digest);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Blob not found for hash " + entry.getContentHash());
        }
        finally {
            out.close();
        }
        if (this.verifyFileIntegrity && !(expectedHash = entry.getContentHash()).equals(actualHash = Hash.hashForMessageDigest(digest))) {
            throw new IOException("Requested hash" + expectedHash + ", but received " + actualHash);
        }
    }

    private void addHeaders(HttpMethod method) {
        for (Map.Entry<String, String> header : this.requestHeaders.entrySet()) {
            method.addRequestHeader(header.getKey(), header.getValue());
        }
        if (!StringUtil.isEmpty((String)this.basicAuthUser) && !StringUtil.isEmpty((String)this.basicAuthPassword)) {
            HttpState httpState = this.client.getState();
            httpState.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.basicAuthUser, this.basicAuthPassword));
        }
    }

    class DirectDownloadHandler
    implements DownloadHandler {
        DirectDownloadHandler() {
        }

        public void download(InputStream in, EntryFilePair pair) throws IOException {
            ClientPathEntry entry = pair.getEntry();
            File file = pair.getFile();
            log.info((Object)("Downloading file '" + file + "'"));
            IO.mkdirs((File)file.getParentFile());
            file.delete();
            FileOutputStream out = new FileOutputStream(file);
            try {
                Client.this.copyFileFromDownload(in, out, pair.getEntry());
            }
            catch (IOException e) {
                file.delete();
                throw e;
            }
            Client.this.applyMetadata(entry, file);
        }
    }

    class CacheDownloadHandler
    implements DownloadHandler {
        CacheDownloadHandler() {
        }

        public void download(InputStream in, EntryFilePair pair) throws IOException {
            ClientPathEntry entry = pair.getEntry();
            log.info((Object)("Caching file '" + entry.getPath() + "'"));
            byte[] hash = entry.getContentHash().getBytes();
            CacheStagingFile stageFile = Client.this.cache.stage(hash);
            try {
                Client.this.copyFileFromDownload(in, stageFile.getStream(), entry);
                stageFile.commit();
            }
            catch (IOException e) {
                stageFile.abort();
                throw e;
            }
        }
    }

    static interface DownloadHandler {
        public void download(InputStream var1, EntryFilePair var2) throws IOException;
    }
}

