/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.ubuild.codestation.client.ArtifactDeliverPattern;
import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.BuildLife;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

class ArtifactDeliverPatternLookup {
    private final String url;
    private final AuthenticationCredentials credentials;
    private final HttpClient httpClient;

    ArtifactDeliverPatternLookup(String url, AuthenticationCredentials credentials, HttpClient httpClient) {
        this.url = url;
        this.credentials = credentials;
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArtifactDeliverPattern[] findArtifactDeliverPatterns(BuildLife buildLife) throws Exception {
        String findUrl = UriBuilder.fromPath((String)this.url).path("build-lives").path(buildLife.getId()).path("artifact-configs").build(new Object[0]).toString();
        ArtifactDeliverPattern[] artifactPatterns = new ArtifactDeliverPattern[]{};
        GetMethod method = new GetMethod(findUrl);
        try {
            method.setFollowRedirects(false);
            if (this.credentials != null) {
                String authToken = this.credentials.getAuthToken();
                if (!StringUtil.isEmpty((String)authToken)) {
                    method.addRequestHeader("Authorization-Token", authToken);
                }
                String username = this.credentials.getUsername();
                String password = this.credentials.getPassword();
                if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                    HttpState httpState = this.httpClient.getState();
                    httpState.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                }
            }
            int code = this.httpClient.executeMethod((HttpMethod)method);
            switch (code) {
                case 200: {
                    String body = method.getResponseBodyAsString();
                    JSONObject json = new JSONObject(body);
                    JSONArray jsonArtifactPatterns = json.getJSONArray("artifactPatterns");
                    artifactPatterns = new ArtifactDeliverPattern[jsonArtifactPatterns.length()];
                    for (int i = 0; i < jsonArtifactPatterns.length(); ++i) {
                        JSONObject jsonArtifactPattern = jsonArtifactPatterns.getJSONObject(i);
                        String artifactSet = jsonArtifactPattern.getString("set");
                        String baseDirectory = jsonArtifactPattern.getString("dir");
                        JSONArray jsonIncludes = jsonArtifactPattern.getJSONArray("includes");
                        String[] includes = this.jsonArrayToStringArray(jsonIncludes);
                        JSONArray jsonExcludes = jsonArtifactPattern.getJSONArray("excludes");
                        String[] excludes = this.jsonArrayToStringArray(jsonExcludes);
                        artifactPatterns[i] = new ArtifactDeliverPattern(artifactSet, baseDirectory, includes, excludes);
                    }
                    break;
                }
                case 204: 
                case 404: {
                    throw new Exception("Build life not found to read artifact configurations: " + buildLife.getId());
                }
                case 500: {
                    throw new Exception("Server error looking up build life: " + method.getResponseBodyAsString());
                }
                default: {
                    throw new Exception("Unexpected response from server: " + code);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
        return artifactPatterns;
    }

    private String[] jsonArrayToStringArray(JSONArray jsonArray) throws JSONException {
        String[] stringArray = new String[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringArray[i] = jsonArray.getString(i);
        }
        return stringArray;
    }
}

