/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.ubuild.codestation.client.ArtifactDeliverPattern;
import com.urbancode.ubuild.codestation.client.ArtifactDeliverPatternLookup;
import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.client.BuildProcessLookup;
import com.urbancode.ubuild.codestation.xml.Dependency;
import org.apache.commons.httpclient.HttpClient;

public class BuildLife {
    private final String buildLifeId;
    private final String codestationBuildLifeId;
    private final String repoId;
    private final String projectId;
    private final String processId;
    private final String codestationProjectId;
    private BuildProcess buildProcess;

    static BuildLife newBuildLife(String buildLifeId, String repoId, String projectId, String processId) {
        return new BuildLife(buildLifeId, null, repoId, projectId, processId, null);
    }

    static BuildLife newCodestationBuildLife(String codestationBuildLifeId, String repoId, String codestationProjectId) {
        return new BuildLife(null, codestationBuildLifeId, repoId, null, null, codestationProjectId);
    }

    static BuildLife fromDependency(Dependency dependency) {
        BuildLife buildLife = null;
        if (dependency.getCriteria() != null && dependency.getCriteria().getBuildLifeId() != null) {
            if (dependency.getProject() != null) {
                buildLife = BuildLife.newBuildLife(dependency.getCriteria().getBuildLifeId().toString(), dependency.getProject().getRepositoryId(), dependency.getProject().getProjectId().toString(), dependency.getProject().getProcessId().toString());
            } else if (dependency.getCsProject() != null) {
                buildLife = BuildLife.newCodestationBuildLife(dependency.getCriteria().getBuildLifeId().toString(), dependency.getCsProject().getRepositoryId(), dependency.getCsProject().getProjectId().toString());
            }
        }
        return buildLife;
    }

    private BuildLife(String buildLifeId, String codestationBuildLifeId, String repoId, String projectId, String processId, String codestationProjectId) {
        this.buildLifeId = buildLifeId;
        this.codestationBuildLifeId = codestationBuildLifeId;
        this.repoId = repoId;
        this.projectId = projectId;
        this.processId = processId;
        this.codestationProjectId = codestationProjectId;
    }

    public boolean isCodestation() {
        return this.codestationBuildLifeId != null;
    }

    public String getId() {
        return this.buildLifeId != null ? this.buildLifeId : this.codestationBuildLifeId;
    }

    public String getRepositoryId() {
        return this.repoId;
    }

    public BuildProcess lookupBuildProcess(String url, AuthenticationCredentials credentials, HttpClient httpClient) throws Exception {
        if (this.buildProcess == null) {
            BuildProcessLookup lookup = new BuildProcessLookup(url, credentials, httpClient);
            this.buildProcess = lookup.findBuildProcess(this.projectId, this.processId);
            ArtifactDeliverPatternLookup adpLookup = new ArtifactDeliverPatternLookup(url, credentials, httpClient);
            ArtifactDeliverPattern[] artifactDeliverPatterns = adpLookup.findArtifactDeliverPatterns(this);
            this.buildProcess.setArtifactDeliverPatterns(artifactDeliverPatterns);
        }
        return this.buildProcess;
    }

    public String toString() {
        String s = super.toString();
        if (this.buildLifeId != null) {
            s = "Build Life " + this.buildLifeId;
        } else if (this.codestationBuildLifeId != null) {
            s = "CodeStation Build Life " + this.buildLifeId;
        }
        return s;
    }
}

