/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.ubuild.codestation.client.ArtifactUploadException;
import com.urbancode.ubuild.codestation.client.VfsClientFactory;
import com.urbancode.vfs.client.Client;
import com.urbancode.vfs.common.ClientChangeSet;
import com.urbancode.vfs.common.ClientPathEntry;
import com.urbancode.vfs.common.ClientRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArtifactUploader
extends VfsClientFactory {
    private static final Logger log = Logger.getLogger(ArtifactUploader.class);
    private final Client client;
    private boolean failIfNotFound = false;

    ArtifactUploader(Client client) {
        this.client = client;
    }

    public void setFailIfNotFound(boolean failIfNotFound) {
        this.failIfNotFound = failIfNotFound;
    }

    void uploadArtifacts(String repoId, String artifactSet, File baseDirectory, String[] includes, String[] excludes, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions, FileListerBuilder.Symlinks symlinks, String hashAlgorithm, List<String> additionalDigestAlgorithms) throws ArtifactUploadException {
        try {
            ClientRepository repo;
            String latestChangeSetId;
            if (this.isUploadToSpecificPath(artifactSet)) {
                artifactSet = this.formatArtifactPath(artifactSet);
            }
            ArrayList<String> hashAlgorithms = new ArrayList<String>();
            hashAlgorithms.add(hashAlgorithm);
            if (additionalDigestAlgorithms != null) {
                hashAlgorithms.addAll(additionalDigestAlgorithms);
            }
            ClientChangeSet latestChangeSet = (latestChangeSetId = (repo = this.client.getRepository(repoId)).getLatestChangeSet()) != null ? this.client.getLatestChangeSet(repoId) : null;
            log.info((Object)("Uploading artifacts from " + baseDirectory.getAbsolutePath()));
            if (includes != null) {
                log.info((Object)("Including [" + StringUtil.join((String[])includes, (String)", ") + "]"));
            }
            if (excludes != null) {
                log.info((Object)("Excluding [" + StringUtil.join((String[])excludes, (String)", ") + "]"));
            }
            ClientPathEntry[] entries = ClientPathEntry.createPathEntriesFromFileSystemWithPrefix((File)baseDirectory, (String[])includes, (String[])excludes, (String)artifactSet, (FileListerBuilder.Directories)directories, (FileListerBuilder.Permissions)permissions, (FileListerBuilder.Symlinks)symlinks, (String[])hashAlgorithms.toArray(new String[0]));
            if (this.failIfNotFound) {
                String entry;
                if (!baseDirectory.exists() || !baseDirectory.isDirectory()) {
                    throw new Exception("The directory containing the artifacts does not exist.");
                }
                if (entries.length == 1 && (entry = entries[0].getName() + "/").equals(artifactSet)) {
                    throw new Exception("There were no artifacts to upload.");
                }
            }
            String stageId = this.client.createStagingDirectory();
            try {
                ClientChangeSet changeSet;
                for (ClientPathEntry entry : entries) {
                    if (!FileType.REGULAR.equals((Object)entry.getType())) continue;
                    String filePath = entry.getPath();
                    if (this.isUploadToSpecificPath(artifactSet)) {
                        filePath = filePath.substring(artifactSet.length());
                    }
                    File entryFile = new File(baseDirectory, filePath);
                    log.info((Object)("Adding " + filePath + " for upload..."));
                    this.client.addFileToStagingDirectory(stageId, entry.getPath(), entryFile);
                }
                if (latestChangeSet == null) {
                    changeSet = ClientChangeSet.newChangeSet((String)repoId, (String)"codestation", (String)"", (ClientPathEntry[])entries);
                    log.debug((Object)"Creating first change set for repository...");
                } else {
                    changeSet = latestChangeSet.addEntries("codestation", "", false, entries);
                    log.debug((Object)"Adding a new change set for repository...");
                }
                log.debug((Object)"Committing change set...");
                String changeSetId = this.client.commitStagingDirectory(stageId, changeSet);
                log.debug((Object)("Created change set: " + changeSetId));
            }
            catch (Exception e) {
                this.client.deleteStagingDirectory(stageId);
                throw e;
            }
        }
        catch (Exception e) {
            throw new ArtifactUploadException("Unable to upload artifacts to " + repoId + " from " + baseDirectory + ": " + e.getMessage(), e);
        }
    }

    private boolean isUploadToSpecificPath(String artifactSet) {
        return !StringUtil.isEmpty((String)artifactSet) && !".".equals(artifactSet);
    }

    private String formatArtifactPath(String artifactSet) {
        if (!(artifactSet = artifactSet.replace('\\', '/')).endsWith("/")) {
            artifactSet = artifactSet + "/";
        }
        return artifactSet;
    }
}

