/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.crypto.MACAlgorithm;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class PRF {
    static final Charset utf8 = Charset.forName("UTF8");
    private final byte[] seed;
    private final Mac mac;
    private byte[] a;

    PRF(SecretContainer secret, String label, byte[] seed, MACAlgorithm alg) throws GeneralSecurityException {
        secret.getClass();
        label.getClass();
        seed.getClass();
        alg.getClass();
        this.seed = this.concat(label.getBytes(utf8), seed);
        this.mac = alg.createMac();
        this.a = seed;
        this.mac.init(new SecretKeySpec(secret.getSecret(), this.mac.getAlgorithm()));
    }

    synchronized byte[] getBytes(int length) {
        byte[] hash;
        int len = 0;
        byte[] out = new byte[length];
        do {
            this.a = this.mac.doFinal(this.a);
            this.mac.update(this.a);
            hash = this.mac.doFinal(this.seed);
            System.arraycopy(hash, 0, out, len, Math.min(hash.length, length - len));
        } while ((len += hash.length) < length);
        return out;
    }

    private byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }
}

