/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.util.Date;

//--------------------------------------------------------------------------------------------------
// Initialization
//--------------------------------------------------------------------------------------------------
final def workDir = new File('.').canonicalFile
final def dateParser = new DateParser();
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def stepProps = apTool.getStepProperties();

//--------------------------------------------------------------------------------------------------
// Repository Properties
//--------------------------------------------------------------------------------------------------
final String scmCmd     = stepProps['source/repo/commandPath']
final String baseUrl    = stepProps['source/repo/repoBaseUrl']
final String username   = stepProps['source/repo/username']
final String password   = stepProps['source/repo/password'] ?: stepProps['source/repo/passScript']

//--------------------------------------------------------------------------------------------------
// Source Properties
//--------------------------------------------------------------------------------------------------
final String srcName            = stepProps['source'];
final File dir                  = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile
final String remoteUrl          = stepProps['source/remoteUrl']
final String tagName            = stepProps['source/tagName']
final String sourceBranch       = stepProps['source/branch']
final String remoteName         = stepProps['source/remoteName']
final String sourceRevision     = stepProps['source/revision'];
final String userExcludesString = stepProps['source/excludeUsers'] ?: ''
final String fileFiltersString  = stepProps['source/fileFilters'] ?: ''

//--------------------------------------------------------------------------------------------------
// Step Properties
//--------------------------------------------------------------------------------------------------
// look for date based checkout (buildlife, then actual workspace date)
final Date date = dateParser.parseDate(stepProps['date'])

//--------------------------------------------------------------------------------------------------
// Buildlife Properties
//--------------------------------------------------------------------------------------------------
final String blRevision = stepProps["buildlife/workspace.revision.$srcName"]
final String blBranch   = stepProps["buildlife/workspace.branch.$srcName"]
// optional trigger property for the fetch
final String fetchRef   = stepProps["buildlife/workspace.ref.$srcName"]
final Date blDate       = dateParser.parseDate(stepProps['buildlife/workspace.date.$srcName'])

//--------------------------------------------------------------------------------------------------
// Perform step
//--------------------------------------------------------------------------------------------------
dir.mkdirs()

SCMCheckout step = new SCMCheckout()
step.directory  = dir
step.scmCommand = scmCmd
step.remoteBaseUrl  = baseUrl
step.remoteUser = username
step.remotePass = password
step.remoteUrl  = remoteUrl
step.tagName    = tagName
step.remoteName = remoteName
step.branch     = blBranch ?: sourceBranch
step.revision   = blRevision ?: sourceRevision
step.date       = blDate ?: date
step.fetchRef   = fetchRef
step.execute()

if (step.remoteBaseUrl) {
    println ""
    println "Updating workspace remote base URL on buildlife to $step.remoteBaseUrl"
    apTool.setOutputProperty("buildlife/workspace.remoteBaseUrl.$srcName", step.remoteBaseUrl)
    println ""
}

if (step.remoteUrl) {
    println ""
    println "Updating workspace remote URL on buildlife to $step.remoteUrl"
    apTool.setOutputProperty("buildlife/workspace.remoteUrl.$srcName", step.remoteUrl)
    println ""
}

if (step.branch && blBranch != step.branch) {
    println "Updating workspace branch on buildlife to $step.branch"
    apTool.setOutputProperty("buildlife/workspace.branch.$srcName", step.branch)
    println ""
}

if (step.revision) {
    if (blRevision != step.revision) {
        println "Updating workspace revision on buildlife to $step.revision"
        apTool.setOutputProperty("buildlife/workspace.revision.$srcName", step.revision)
        println ""
    }
}
else if (step.date) {
    if (blDate != step.date) {
        println "Updating workspace date on buildlife to $step.date"
        apTool.setOutputProperty("buildlife/workspace.date.$srcName", step.date.toString())
        println ""
    }
}

apTool.storeOutputProperties()
