/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.commons.fileutils.DirectoryFileFilter;
import com.urbancode.commons.fileutils.FileUtils;

public class FileHelper {

    static public String getFilePath(String baseDirectory, String includes) {
        File baseDir = new File(baseDirectory)
        DirectoryFileFilter filter = DirectoryFileFilter.getFilter(baseDir)
        includes.eachLine { includeRule ->
            if (includeRule != null && includeRule.trim().length() > 0) {
                filter.addInclude(includeRule.trim());
            }
        }

        File[] files = FileUtils.getFilesRecursively(baseDir, filter)

        String separator = File.pathSeparator
        String[] paths = files.collect{it.absolutePath};
        String result = paths.join(separator);

        return result;
    }

}
