/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

import com.urbancode.commons.fileutils.DirectoryFileFilter;
import com.urbancode.commons.fileutils.FileUtils;

def apTool = new AirPluginTool(this.args[0], this.args[1])

/* Here we call getStepProperties() to get a Properties object that contains the step properties
 * provided by the user.
 */
def stepProps = apTool.getStepProperties()

// commandHelper
final def workDir = new File('.').canonicalFile
def commandHelper = new CommandHelper(workDir);
//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

final String osName = System.getProperty('os.name').toLowerCase(Locale.US)
final boolean windows = (osName =~ /windows/)

def step_definitionsBase            = stepProps['step_definitionsBase']
def step_def_includes           = stepProps['step_def_includes']
def implementationBase              = stepProps['implementationBase']
def impl_includes               = stepProps['impl_includes']
def javaHome                    = stepProps['javaHome']
def javaClasspathBase                   = stepProps['javaClasspathBase']
def classpath_includes          = stepProps['classpath_includes']

//
// Validation
//
assert !workDir.isFile() : "Working directory ${workDir} is a file!"

// ensure work-dir exists
workDir.mkdirs()

//
// Build Command Line
//
def commandLine = []

def javacPath = "javac"
if (javaHome) {
    if (windows) {
        javacPath = javaHome + "\\bin\\javac.exe"
    }
    else {
        javacPath = javaHome + "/bin/javac"
    }
}

commandLine << javacPath

if (javaClasspathBase) {
    commandLine << "-cp"
    def classPath = FileHelper.getFilePath(javaClasspathBase, classpath_includes);
    commandLine << classPath
}

def stepDefPath = FileHelper.getFilePath(step_definitionsBase, step_def_includes);
commandLine << stepDefPath

if (implementationBase) {
    def implPath = FileHelper.getFilePath(implementationBase, impl_includes);
    commandLine << implPath
}

commandHelper.runCommand('Compiling step definition for Cucumber CLI', commandLine);

//write the output properties to the file
apTool.storeOutputProperties()

