/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

def apTool = new AirPluginTool(this.args[0], this.args[1]) 


final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile

def dockerHost = stepProps['dockerHost']
def imagePropName = stepProps['imagePropName']
def imageTagName = stepProps['imageTagName']
def buildFlags = stepProps['buildFlags']

def commandHelper = new CommandHelper(workDir)
def commandLine = ['docker']
if (dockerHost) {
	println "Using Docker host ${dockerHost}"
    commandLine << "-H=${dockerHost}"
}
commandLine << 'build'
if (buildFlags) {
    buildFlags.split('\\s+').each() { buildFlag ->
        if (buildFlag) {
            commandLine << buildFlag
        }
    }
}
if (imageTagName) {
	commandLine << '-t'
	commandLine << imageTagName
}
commandLine << '.'
if (imagePropName) {
	commandHelper.runCommand("Docker Build", commandLine) { Process proc ->
	    proc.out.close()                    // close   the stdIn  of the process
	    proc.consumeProcessErrorStream(System.out) // forward the stdErr of the process
	    proc.in.withReader{
	         String line = null
	         while ((line = it.readLine()) != null)  {
	         	 println line
	             if (line.startsWith('Successfully built ')) {
	             	def imageId = line.substring('Successfully built '.length())
	    			apTool.setOutputProperty("buildlife/${imagePropName}", imageId)
	    			apTool.setOutputProperties()
	    			println "Set '${imagePropName}' property to '${imageId}'"
	             }
	         }
		}
	}
}
else {
	commandHelper.runCommand("Docker Build", commandLine)
}