/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])

final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile

def dockerHost = stepProps['dockerHost']
def imageName = stepProps['imageName']
def username = stepProps['username']
def password = stepProps['password']
def email = stepProps['email']
def server = stepProps['server']

def commandHelper = new CommandHelper(workDir)
boolean isLogined = false
int exitCode = -1

if (username && password && email) {
    def loginCommandLine = ['docker']
    if (dockerHost) {
        println "Using Docker host ${dockerHost}"
        loginCommandLine << "-H=${dockerHost}"
    }

    loginCommandLine << 'login'
    loginCommandLine << "-u=${username}"
    loginCommandLine << "-p=${password}"
    loginCommandLine << "-e=${email}"


    if (server) {
        loginCommandLine << server
    }
    loginResult = commandHelper.runCommand("Logging in to the Docker registry", loginCommandLine)
    isLogined = true
} else if (username || password || email) {
    println "If any one of the username,password,server information is available, all of them should be available."
    System.exit(exitCode)
}

def pushCommandLine = ['docker']
if (dockerHost) {
    println "Using Docker host ${dockerHost}"
    pushCommandLine << "-H=${dockerHost}"
}
pushCommandLine << 'push'
pushCommandLine << imageName
commandHelper.runCommand("Pushing image $imageName to the Docker registry", pushCommandLine)

if (isLogined) {
    def logoutCommandLine = ['docker']
    if (dockerHost) {
        println "Using Docker host ${dockerHost}"
        logoutCommandLine << "-H=${dockerHost}"
    }
    logoutCommandLine << 'logout'
    if (server) {
        logoutCommandLine << server
    }
    commandHelper.runCommand("Logging out the Docker registry", logoutCommandLine)
}
