/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Build
 * (c) Copyright IBM Corporation 2012, 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])


final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile

String dockerFile = stepProps['dockerFile']
String imagePropName = stepProps['imagePropName']
String dockerOptions = stepProps['dockerOptions']
String buildFlags = stepProps['buildFlags']
String dockerBuildOptions = stepProps['dockerBuildOptions']

CommandHelper commandHelper = new CommandHelper(workDir)
def commandLine = ['docker']
if (dockerFile) {
    println "Using Docker file ${dockerFile} to build docker image"
    if (dockerOptions) {
        dockerOptions.split('\\s+').each() { dockerOption ->
            if (dockerOption) {
                commandLine << dockerOption
            }
        }
    }
    commandLine << 'build'
    if (buildFlags) {
        buildFlags.split('\\s+').each() { buildFlag ->
            if (buildFlag) {
                commandLine << buildFlag
            }
        }
    }
    if (dockerBuildOptions) {
        dockerBuildOptions.split('\\s+').each() { dockerBuildOption ->
            if (dockerBuildOption) {
                commandLine << dockerBuildOption
            }
        }
    }
    commandLine << dockerFile
    if (imagePropName) {
        commandHelper.runCommand("Docker Build", commandLine) { Process proc ->
            proc.out.close()                    // close   the stdIn  of the process
            proc.consumeProcessErrorStream(System.out) // forward the stdErr of the process
            proc.in.withReader {
                String line = null
                while ((line = it.readLine()) != null) {
                    println line
                    if (line.startsWith('Successfully built ')) {
                        def imageId = line.substring('Successfully built '.length())
                        apTool.setOutputProperty("buildlife/${imagePropName}", imageId)
                        apTool.setOutputProperties()
                        println "Set '${imagePropName}' property to '${imageId}'"
                    }
                }
            }
        }
    }
    else {
        commandHelper.runCommand("Docker Build", commandLine)
    }

}
else {
    throw new Exception("${dockerFile} is not valid! Validation failed!")
}