/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Build
 * (c) Copyright IBM Corporation 2012, 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])

final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile

String imageName = stepProps['imageName']
String dockerOptions = stepProps['dockerOptions']
Boolean skipImageSigning = Boolean.parseBoolean(stepProps['skipImageSigning'])
String server = stepProps['server']

CommandHelper commandHelper = new CommandHelper(workDir)

String dockerRuntimeOptions

if (dockerOptions) {
    dockerOptions.split('\\s+').each() { dockerOption ->
        if (dockerOption) {
            dockerRuntimeOptions << dockerOption
        }
    }
}

def pushCommandLine = ['docker']
if (dockerRuntimeOptions) {
    pushCommandLine << dockerRuntimeOptions
}
pushCommandLine << 'push'
pushCommandLine << "--disable-content-trust=$skipImageSigning"
pushCommandLine << "${server}/${imageName}"
commandHelper.runCommand("Pushing image $imageName to the Docker registry", pushCommandLine)

