/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto.algs;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.ObjectUtil;
import com.urbancode.commons.util.crypto.algs.CryptStringAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

@BridgeMethodsAdded
public class DESAlg
implements CryptStringAlgorithm {
    private static final String DESEDE_ALG = "DESede";

    public String getAlgPrefix() {
        return DESEDE_ALG;
    }

    public boolean isSupported() {
        return true;
    }

    public String encode(String value) throws GeneralSecurityException {
        return this.encryptDESede(value);
    }

    public boolean isDecodeSupported() {
        return true;
    }

    public String decode(String encoded) throws GeneralSecurityException {
        return this.decryptDESede(encoded);
    }

    public boolean validate(String plainText, String cipherText) throws GeneralSecurityException {
        return ObjectUtil.isEqual(plainText, this.decode(cipherText));
    }

    protected String encryptDESede(String value) throws GeneralSecurityException {
        String result;
        if (value != null) {
            byte[] plainBytes = this.getUtf8Bytes(value);
            byte[] encKeyBytes = null;
            byte[] cryptBytes = null;
            byte[] data = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            KeyGenerator keygen = KeyGenerator.getInstance(DESEDE_ALG);
            keygen.init(sr);
            SecretKey key = keygen.generateKey();
            encKeyBytes = this.encodeKeyBytes(key.getEncoded());
            Cipher cipher = Cipher.getInstance(DESEDE_ALG);
            cipher.init(1, (Key)key, sr);
            cryptBytes = cipher.doFinal(plainBytes);
            try {
                baos.write(encKeyBytes);
                baos.write(cryptBytes);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            data = baos.toByteArray();
            result = Base64.encodeBase64String((byte[])data);
            try {
                baos.close();
            }
            catch (IOException ioe) {}
        } else {
            result = null;
        }
        return result;
    }

    protected String decryptDESede(String cryptToken) throws GeneralSecurityException {
        String result;
        if (cryptToken != null) {
            byte[] data;
            String strippedToken = cryptToken;
            try {
                data = Base64.decodeBase64((byte[])strippedToken.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException impossible) {
                throw new AssertionError((Object)impossible);
            }
            byte[] encKeyBytes = new byte[24];
            byte[] cryptBytes = new byte[data.length - encKeyBytes.length];
            byte[] plainBytes = null;
            System.arraycopy(data, 0, encKeyBytes, 0, encKeyBytes.length);
            System.arraycopy(data, encKeyBytes.length, cryptBytes, 0, cryptBytes.length);
            SecretKeySpec key = new SecretKeySpec(this.decodeKeyBytes(encKeyBytes), DESEDE_ALG);
            Cipher cipher = Cipher.getInstance(DESEDE_ALG);
            cipher.init(2, key);
            plainBytes = cipher.doFinal(cryptBytes);
            try {
                result = new String(plainBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
        result = cryptToken;
        return result;
    }

    private byte[] encodeKeyBytes(byte[] keyBytes) {
        int i;
        byte[] encKeyBytes = new byte[keyBytes.length];
        System.arraycopy(keyBytes, 0, encKeyBytes, 0, keyBytes.length);
        for (i = 0; i < encKeyBytes.length; ++i) {
            int n = i;
            encKeyBytes[n] = (byte)(encKeyBytes[n] ^ i * 7 % 128);
            if (i <= 1) continue;
            int n2 = i;
            encKeyBytes[n2] = (byte)(encKeyBytes[n2] ^ keyBytes[i - 1]);
        }
        for (i = 0; i < encKeyBytes.length / 2; i += 2) {
            int index1 = i;
            int index2 = encKeyBytes.length - 1 - i;
            byte temp = encKeyBytes[index1];
            encKeyBytes[index1] = encKeyBytes[index2];
            encKeyBytes[index2] = temp;
        }
        for (i = 1; i < encKeyBytes.length; i += 3) {
            byte reversebyte = 0;
            for (int j = 0; j < 8; ++j) {
                reversebyte = (byte)(reversebyte | (encKeyBytes[i] >> j & 1) << 7 - j);
            }
            encKeyBytes[i] = reversebyte;
        }
        return encKeyBytes;
    }

    private byte[] decodeKeyBytes(byte[] encKeyBytes) {
        int i;
        byte[] keyBytes = new byte[encKeyBytes.length];
        System.arraycopy(encKeyBytes, 0, keyBytes, 0, encKeyBytes.length);
        for (i = 1; i < keyBytes.length; i += 3) {
            byte reversebyte = 0;
            for (int j = 0; j < 8; ++j) {
                reversebyte = (byte)(reversebyte | (keyBytes[i] >> j & 1) << 7 - j);
            }
            keyBytes[i] = reversebyte;
        }
        for (i = 0; i < keyBytes.length / 2; i += 2) {
            int index1 = i;
            int index2 = keyBytes.length - 1 - i;
            byte temp = keyBytes[index1];
            keyBytes[index1] = keyBytes[index2];
            keyBytes[index2] = temp;
        }
        for (i = 0; i < keyBytes.length; ++i) {
            int n = i;
            keyBytes[n] = (byte)(keyBytes[n] ^ i * 7 % 128);
            if (i <= 1) continue;
            int n2 = i;
            keyBytes[n2] = (byte)(keyBytes[n2] ^ keyBytes[i - 1]);
        }
        return keyBytes;
    }

    private byte[] getUtf8Bytes(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is unsupported, but this is required in JVM spec", e);
        }
    }
}

