package com.urbancode.air.plugin.scm

import com.urbancode.air.*
import com.urbancode.air.plugin.scm.changelog.*

import java.util.Date
import java.util.TimeZone
import java.util.regex.Pattern
import java.text.SimpleDateFormat

import org.apache.commons.httpclient.HttpClient
import org.apache.commons.httpclient.UsernamePasswordCredentials
import org.apache.commons.httpclient.auth.AuthScope
import org.apache.commons.httpclient.methods.StringRequestEntity
import org.apache.commons.httpclient.methods.PostMethod
import org.apache.commons.httpclient.params.HttpClientParams
import org.apache.commons.httpclient.protocol.Protocol
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory

import com.urbancode.commons.util.IO
import com.urbancode.commons.util.https.OpenSSLProtocolSocketFactory


public class SCMChangelog {

    //**************************************************************************
    // CLASS
    //**************************************************************************
    final protected static String REPO_TYPE = "FileSystem"
    
    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    // changelog boundaries
    Date startDate = null
    Date endDate = null
    String changesUrl = null
    File dir = null

    // filters for changeset
    final ChangeSetFilter changeSetFilter = new ChangeSetFilter()
    Map<Date, ChangeSet> changeSets

    /**
     *
     * @return xml document of changes
     */
    public def execute() {
        changeSets = new HashMap<ChangeSet>()
        
        getChangeHistory(dir)
        
        // Construct xml message and send to server
        if (changeSets) {
            ChangeSetXMLHelper xmlHelper = new ChangeSetXMLHelper()
            xmlHelper.repoType = REPO_TYPE
            String xml = xmlHelper.toXML(changeSets, dir)
            sendPostRequest(xml)
        }
        else {
            println "No changes detected"
        }
    }
    
    private void getChangeHistory(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles()
            for (int i = 0; i < fileArray.length; i++) {
                if (fileArray[i].isDirectory()) {
                    getChangeHistory(fileArray[i])
                }
                else {
                    Date lastModified = new Date(fileArray[i].lastModified())
                    if (startDate.before(lastModified) && endDate.after(lastModified)) {
                        ChangeSet changeSet = changeSets.get(lastModified)
                        
                        if (!changeSet) {
                            changeSet = new ChangeSet()
                            changeSet.date = lastModified
                            changeSet.fileSet << fileArray[i]
                            
                            if (changeSet.hasAllowedPath(changeSetFilter)) {
                                changeSets.put(lastModified, changeSet)
                            }
                        }
                        else {
                            changeSet.fileSet << fileArray[i]
                            
                            if (!changeSet.hasAllowedPath(changeSetFilter)) {
                                changeSet.fileSet.remove(fileArray[i])
                            }
                        }
                    }
                }
            }
        }
    }
    
    private void sendPostRequest(String xml) {
        // construct the URL with property replacements
        String url = changesUrl
        def authToken = System.getenv("AUTH_TOKEN")
        
        println "Sending request to $url"

        // Debug/testing stub
       if (url.startsWith("file://")) {
           File xmlOut = new File(dir, "xmlOut.xml")
           xmlOut << xml
       }
       else {
           ProtocolSocketFactory socketFactory = new OpenSSLProtocolSocketFactory()
           Protocol https = new Protocol("https", socketFactory, 443)
           Protocol.registerProtocol("https", https)
    
           PostMethod postMethod = new PostMethod(url)
           if (authToken) {
               postMethod.setRequestHeader("Authorization-Token", authToken)
               postMethod.setRequestHeader("Content-Type", "application/xml")
           }
           
           println "Sending ${changeSets.size()} changes"
           postMethod.setRequestEntity(new StringRequestEntity(xml))
    
           HttpClient client = new HttpClient()
    
           def responseCode = client.executeMethod(postMethod)
           InputStream responseStream = postMethod.getResponseBodyAsStream()
           if (isGoodResponseCode(responseCode)) {
               IO.copy(responseStream, System.out)
               println ""
           }
           else {
               IO.copy(responseStream, System.err)
               throw new RuntimeException("Failed to upload source changes. StatusCode: ${responseCode}")
           }
       }
    }
    
    private boolean isGoodResponseCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300
    }
}