/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def workDir = new File('.').canonicalFile

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------

final def apTool = new AirPluginTool(this.args[0], this.args[1]);
final stepProps = apTool.getStepProperties()

final def srcName      = stepProps['source'];
final String username  = stepProps['source/repo/username']
final String password  = stepProps['source/repo/password']
final def dir          = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory

//------------------------------------------------------------------------------
// PREPARE COMMAND LINE
//------------------------------------------------------------------------------

 println "Deleting directory contents for $dir"
 dir.listFiles().each{ file ->
     boolean success = false;
     if (file.isFile()) {
         success = file.delete()
     }
     else if (file.isDirectory()){
         success = file.deleteDir()
     }
     if (!success) {
         println("Failed to delete $file")
     }
 }
 println "Done deleting directory contents for $dir"
