/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.text.*


final def dateParser = new DateParser();
final def apTool = new AirPluginTool(this.args[0], this.args[1]);

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------
final File workDir = new File('.').canonicalFile

final def stepProps = apTool.getStepProperties();

final def srcName               = stepProps['source'];
final File dir                  = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory
final def startDate             = dateParser.parseDate(stepProps['startDate'])
final def endDate               = dateParser.parseDate(stepProps['endDate'])

// create the directory ahead of time
dir.mkdirs()

println "Checking Last Modified Date of files in ${dir}"

// Execute
SCMQuietPeriod quietPeriod = new SCMQuietPeriod();
quietPeriod.dir = dir

Date lastModifiedDate = quietPeriod.execute()

//------------------------------------------------------------------------------
// UPLOAD LATEST CHANGE DATE
//------------------------------------------------------------------------------
if (lastModifiedDate == null) {
    println('No changes detected')
}
else {
    apTool.setOutputProperty("job/latest.change.time.${srcName}", String.valueOf(lastModifiedDate.time))
    apTool.storeOutputProperties()
    println "Last Modified Date: ${lastModifiedDate} from ${quietPeriod.lastModifiedFile}" 
}
