/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.text.*

final def dateParser = new DateParser();
final def apTool = new AirPluginTool(this.args[0], this.args[1]);

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile

final String changesUrl = stepProps['changesUrl']
final def startDate     = dateParser.parseDate(stepProps['startDate'])
final def endDate       = dateParser.parseDate(stepProps['endDate'])
final String srcName    = stepProps['source'];
final def fileFiltersString   = stepProps['source/fileFilters'] ?: '';
final File dir          = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory

// create the directory ahead of time
dir.mkdirs()

println "Working Directory: " + dir.getPath()

SCMChangelog log = new SCMChangelog()
log.changesUrl = changesUrl
log.startDate = startDate
log.endDate = endDate
log.dir = dir
log.changeSetFilter.setFileFilters(fileFiltersString)

log.execute()